package ebuild.api.repo;

import java.io.File;

import ebuild.api.log.ILogger;

abstract public class AbstractRepositoryProvider {

	public AbstractWorkingCopy getWorkingCopy(File workingCopy) throws RepositoryPluginException {
		throw new RepositoryPluginException("Unsupported operation");
	}
	public void initLogger(ILogger logger){}
	public void initCredentials(File credentialsFile){}
	abstract public IRepository getRepository(String repositoryUrl) throws RepositoryPluginException;
}
