/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.export.zip;

import ebuild.api.IBuilderArgument;
import ebuild.api.IEBuild;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.util.FileUtil;
import ebuild.util.ZipUtil;
import java.io.File;
import java.util.List;

public class ExportZipBuilder
extends AbstractBuilder {
    public void build(IBuilderArgument argument) throws BuildPluginException {
        IEBuild ebuild = argument.getEBuild();
        ILogger logger = argument.getLogger();
        IPropertyMap props = argument.getPropertyMap();
        String artifact = props.expectString("conf.artifact");
        try {
            List targetFolders = argument.getInputDirs(artifact);
            File archive = argument.getOutputArtifact(String.valueOf(artifact) + ".zip", false);
            FileUtil.mkdirOrFail((File)archive.getParentFile());
            int rootEntries = 0;
            for (File f : targetFolders) {
                rootEntries += f.list().length;
            }
            if (rootEntries > 0) {
                logger.log("Creating archive:");
                logger.log("    " + ebuild.formatAsDisplayPath(archive));
                ZipUtil.zipDirectories((File)archive, (List)targetFolders);
            } else if (targetFolders.size() == 0) {
                logger.warn("No directories for input artifact '" + artifact + "'");
            } else {
                logger.warn("Archive not created, input directories empty:");
                for (File f : targetFolders) {
                    logger.log("    " + ebuild.formatAsDisplayPath(f));
                }
            }
        }
        catch (Exception e) {
            throw new BuildPluginException((Throwable)e);
        }
    }
}

