/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.file.archive;

import ebuild.api.IAssemblerArgument;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.BuildPluginException;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileArchiveAssembler
extends AbstractAssembler {
    public Collection<File> assemble(IAssemblerArgument argument) throws BuildPluginException {
        File basedir = argument.getInputMap().expectLoneInput().expectLoneArtifact();
        File archive = new File(argument.getOutputDirectory(), "archive.zip");
        boolean usePrefix = argument.getPropertyMap().getBool("prefix-path-with-name", false);
        String prefix = usePrefix ? FileUtil.removeSuffix((String)argument.getReleaseFileName()) : "";
        try {
            ZipUtil.zipDirectory((File)archive, (File)basedir, (String)prefix);
        }
        catch (IOException e) {
            throw new BuildPluginException((Throwable)e);
        }
        return CollectionUtil.singletonList((Object)archive);
    }
}

