package ebuild.build.file.archive;


import static ebuild.util.CollectionUtil.singletonList;

import java.io.File;
import java.io.IOException;
import java.util.Collection;

import ebuild.api.IAssemblerArgument;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.BuildPluginException;
import ebuild.util.FileUtil;
import ebuild.util.ZipUtil;

public class FileArchiveAssembler extends AbstractAssembler{
    
    public Collection<File> assemble(IAssemblerArgument argument) throws BuildPluginException {
        File basedir = argument.getInputMap().expectLoneInput().expectLoneArtifact();
        // SHOULD probably check directory and exclude an extra artifacts (and recommend a clean build)
        File archive = new File(argument.getOutputDirectory(), "archive.zip");
        
        boolean usePrefix = argument.getPropertyMap().getBool("prefix-path-with-name", false);
        String prefix = usePrefix?FileUtil.removeSuffix(argument.getReleaseFileName()):"";
        
        try {
			ZipUtil.zipDirectory(archive, basedir, prefix);
		} catch (IOException e) {
			throw new BuildPluginException(e);
		}
        return singletonList(archive);
    }

}
