/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.file.layout;

import ebuild.api.IAssemblerArgument;
import ebuild.api.IEBuild;
import ebuild.api.IInput;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.BuildPluginException;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.JSONUtil;
import ebuild.util.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLayoutAssembler
extends AbstractAssembler {
    private List<Layout> parseJson(String layoutString) {
        Map layoutMap = JSONUtil.readMap((String)layoutString);
        ArrayList<Layout> r = new ArrayList<Layout>(layoutMap.size());
        for (String key : layoutMap.keySet()) {
            String path = (String)layoutMap.get(key);
            boolean dir = path.endsWith("/");
            if (dir) {
                path = path.substring(0, path.length() - 1);
            }
            r.add(new Layout(key, path, dir));
        }
        return r;
    }

    private BuildPluginException badFormat(String got) {
        return new BuildPluginException("Expected <input>: <path>   [| options], got " + got);
    }

    private List<Layout> parseDsl(String layoutString) throws BuildPluginException {
        String[] entries = layoutString.split("\n");
        ArrayList<Layout> r = new ArrayList<Layout>(entries.length);
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (!(e = e.trim()).startsWith("#") && e.length() != 0) {
                String[] key_rest = e.split("->", 2);
                if (key_rest.length != 2) {
                    throw this.badFormat(e);
                }
                String key = key_rest[0].trim();
                String[] path_options = key_rest[1].split("\\|", 2);
                String path = path_options[0].trim();
                String options = path_options.length == 2 ? path_options[1].trim() : "";
                boolean dir = path.endsWith("/");
                if (dir) {
                    path = path.substring(0, path.length() - 1);
                }
                Layout l = new Layout(key, path, dir);
                l.unarchive = options.contains("unarchive");
                l.removeOrg = options.contains("remove-org");
                r.add(l);
            }
            ++n2;
        }
        return r;
    }

    private List<Layout> parse(String layoutString) throws BuildPluginException {
        if (layoutString.startsWith("{")) {
            return this.parseJson(layoutString);
        }
        return this.parseDsl(layoutString);
    }

    public Collection<File> assemble(IAssemblerArgument arg) throws BuildPluginException {
        try {
            IEBuild ebuild = arg.getEBuild();
            ILogger logger = arg.getLogger();
            String layoutString = arg.getPropertyMap().expectString("layout").trim();
            List<Layout> layout = this.parse(layoutString);
            File dir = new File(arg.getOutputDirectory(), "layout");
            for (Layout l : layout) {
                logger.log(l.input);
                IInput input = arg.getInputMap().expectInput(l.input);
                File dest = new File(dir, l.path);
                Collection as = input.getArtifacts();
                if (!l.unarchive) {
                    if (l.dir) {
                        if (as.size() > 0) {
                            dest.mkdirs();
                        }
                        for (File in : as) {
                            int dash;
                            String outName = in.getName();
                            if (l.removeOrg && (dash = outName.indexOf(45)) != -1) {
                                outName = outName.substring(dash + 1);
                            }
                            File out = new File(dest, outName);
                            logger.log("               " + ebuild.formatAsDisplayPath(in));
                            logger.log("    copying -> " + l.path + "/" + outName);
                            FileUtil.copy((File)in, (File)out);
                        }
                        continue;
                    }
                    if (as.size() == 0) continue;
                    File a = input.expectLoneArtifact();
                    dest.getParentFile().mkdirs();
                    logger.log("               " + ebuild.formatAsDisplayPath(a));
                    logger.log("    copying -> " + l.path);
                    FileUtil.copy((File)a, (File)dest);
                    continue;
                }
                if (l.dir) {
                    for (File a : as) {
                        logger.log("               " + ebuild.formatAsDisplayPath(a));
                        logger.log(" extracting -> " + l.path + "/");
                        ZipUtil.unzipArchive((File)a, (File)dest);
                    }
                    continue;
                }
                for (File a : as) {
                    logger.log("               " + ebuild.formatAsDisplayPath(a));
                    logger.log(" extracting -> " + l.path);
                    ZipUtil.unzipArchiveAndRename((File)a, (File)dest);
                }
            }
            return CollectionUtil.singletonList((Object)dir);
        }
        catch (IOException e) {
            throw new BuildPluginException((Throwable)e);
        }
    }

    private class Layout {
        final String input;
        final String path;
        final boolean dir;
        boolean unarchive = false;
        boolean removeOrg = false;

        Layout(String input, String path, boolean dir) {
            this.input = input;
            this.path = path;
            this.dir = dir;
        }
    }
}

