/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.java.compile;

import ebuild.api.IBuilderArgument;
import ebuild.api.IGenConfArgument;
import ebuild.api.IModuleProject;
import ebuild.api.IModuleRelease;
import ebuild.api.IModuleWorkspaceProject;
import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IEclipseNature;
import ebuild.build.java.compile.JDTProject;
import ebuild.build.java.compile.JavacRunner;
import ebuild.util.Callable;
import ebuild.util.IOUtil;
import ebuild.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class JavaBuilder
extends AbstractBuilder
implements IEclipseNature {
    public void build(IBuilderArgument argument) throws BuildPluginException {
        try {
            new JavacRunner(argument).doBuild();
        }
        catch (BuildPluginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildPluginException((Throwable)e);
        }
    }

    public void generateEclipseProjectSettings(IGenConfArgument argument) throws BuildPluginException {
        try {
            new JDTProject(argument).generate();
            if (argument.getPropertyMap().getBool("ebuild-runpath", false)) {
                this.generateDotEBuildRunpath(argument.getModuleWorkspaceProject());
            }
        }
        catch (BuildPluginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildPluginException((Throwable)e);
        }
    }

    private void generateDotEBuildRunpath(final IModuleWorkspaceProject module) throws Exception {
        final ArrayList entries = new ArrayList();
        new Callable(){
            private Set norecur = new HashSet();

            private void addEntry(File f) {
                entries.add(f.getAbsolutePath());
            }

            private void addEntries(IModuleRelease mod) {
                if (this.norecur.contains(mod)) {
                    return;
                }
                this.norecur.add(mod);
                Collection sources = mod.getArtifacts(Scope.MAIN, "java.classes.jar");
                for (File jar : sources) {
                    this.addEntry(jar);
                }
            }

            private void addEntries(IModuleWorkspaceProject mod) {
                IElementKey key = mod.getKey();
                if (key.getOrg().equals("ebuild") && key.getName().startsWith("api")) {
                    return;
                }
                if (this.norecur.contains(mod)) {
                    return;
                }
                this.norecur.add(mod);
                this.addEntry(mod.getProjectFile("bin"));
                Collection checkedArtifacts = mod.getCheckedInArtifacts(Scope.MAIN, "java.classes.jar");
                for (File a : checkedArtifacts) {
                    this.addEntry(mod.getProjectFile("checkedin/" + a.getName()));
                }
                for (IModuleProject mod2 : mod.getWorkspaceDependencies(Scope.MAIN)) {
                    this.addEntries((IModuleWorkspaceProject)mod2);
                }
                for (IModuleProject mod2 : mod.getReleasedDependencies(Scope.MAIN)) {
                    this.addEntries((IModuleRelease)mod2);
                }
            }

            public Object run() throws Exception {
                this.addEntries(module);
                return null;
            }
        }.run();
        IOUtil.stringToFile((String)StringUtil.join((String)"\n", entries), (File)module.getProjectFile(".ebuild-runpath"));
        module.addIgnores(new String[]{".ebuild-runpath"});
    }
}

