package ebuild.build.java.compile;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ebuild.api.IBuilderArgument;
import ebuild.api.IGenConfArgument;
import ebuild.api.IModuleProject;
import ebuild.api.IModuleRelease;
import ebuild.api.IModuleWorkspaceProject;
import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IEclipseNature;
import ebuild.util.Callable;
import ebuild.util.IOUtil;
import ebuild.util.StringUtil;

public class JavaBuilder extends AbstractBuilder implements IEclipseNature{
	
    @Override
	public void build(IBuilderArgument argument) throws BuildPluginException {
		try{
			new JavacRunner(argument).doBuild();
		}catch(BuildPluginException e){
		    throw e;
		}catch(Exception e){
		    throw new BuildPluginException(e);
		}
	}
	
	public void generateEclipseProjectSettings(IGenConfArgument argument) throws BuildPluginException {
        try{
            new JDTProject(argument).generate();
            
            if(argument.getPropertyMap().getBool("ebuild-runpath", false)){
            	generateDotEBuildRunpath(argument.getModuleWorkspaceProject());
            }
            
        }catch(BuildPluginException e){
            throw e;
        }catch(Exception e){
            throw new BuildPluginException(e);
        }
	}
	
	private void generateDotEBuildRunpath(final IModuleWorkspaceProject module) throws Exception{
		final List<String> entries = new ArrayList();
		
		new Callable() {

			private Set norecur = new HashSet();
			private void addEntry(File f){ entries.add(f.getAbsolutePath()); }
            private void addEntries(IModuleRelease mod) {
                if(norecur.contains(mod)) return;
                else norecur.add(mod);
                
                Collection<File> sources = mod.getArtifacts(Scope.MAIN,"java.classes.jar");
                for(File jar: sources){
                    addEntry(jar);
                }
            }
            
            private void addEntries(IModuleWorkspaceProject mod) {
                IElementKey key = mod.getKey();
            	if(key.getOrg().equals("ebuild") && key.getName().startsWith("api"))
                	return;
                
            	if(norecur.contains(mod)) return;
                else norecur.add(mod);
                
                addEntry(mod.getProjectFile("bin"));
				
                Collection<File> checkedArtifacts = mod.getCheckedInArtifacts(Scope.MAIN,"java.classes.jar");
                for(File a: checkedArtifacts){
                	addEntry(mod.getProjectFile("checkedin/"+a.getName()));
                }
                
				for(IModuleProject mod2:  mod.getWorkspaceDependencies(Scope.MAIN)){
				    addEntries((IModuleWorkspaceProject)mod2);
				}
				
				for(IModuleRelease mod2: mod.getReleasedDependencies(Scope.MAIN)){
				    addEntries(mod2);
				}
            }
			public Object run() throws Exception {
			    addEntries(module);
                return null;
			}
		}.run();

		
		IOUtil.stringToFile(StringUtil.join("\n", entries), module.getProjectFile(".ebuild-runpath")); 
		module.addIgnores(".ebuild-runpath");
	}
}
