/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.java.compile;

import ebuild.api.IEBuild;
import ebuild.api.IGenConfArgument;
import ebuild.api.IModuleProject;
import ebuild.api.IModuleRelease;
import ebuild.api.IModuleWorkspaceProject;
import ebuild.api.Scope;
import ebuild.util.Callable;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTProject {
    final IEBuild ebuild;
    protected final IModuleWorkspaceProject module;

    public JDTProject(IGenConfArgument argument) {
        this.ebuild = argument.getEBuild();
        this.module = argument.getModuleWorkspaceProject();
    }

    protected String getJREContainer() {
        return "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.6";
    }

    protected String getInputArtifactType() {
        return "java";
    }

    protected String getSourceArtifactType() {
        return "java.zip";
    }

    protected String getTargetArtifactType() {
        return "java.classes.jar";
    }

    protected List<String> listContainers() {
        return CollectionUtil.singletonList((Object)this.getJREContainer());
    }

    protected void contributeToDotProject() throws IOException {
        this.module.addNature("org.eclipse.jdt.core.javanature");
        this.module.addBuildCommand("org.eclipse.jdt.core.javabuilder");
    }

    private void generateDotClasspath() throws Exception {
        final ArrayList entries = new ArrayList();
        new Callable(){
            private Set<IModuleRelease> norecur = new HashSet<IModuleRelease>();

            private void addEntry(String kind, String path, File sourcepath, boolean export) {
                HashMap<String, String> e = new HashMap<String, String>();
                e.put("kind", kind);
                e.put("path", path);
                e.put("export", export + "");
                if (sourcepath != null) {
                    e.put("sourcepath", sourcepath.getAbsolutePath());
                }
                entries.add(e);
            }

            private File findSourcesArchive(Collection<File> sources, File jar) {
                String name = FileUtil.removeSuffix((String)jar.getName()) + ".zip";
                for (File f : sources) {
                    if (!f.getName().equals(name)) continue;
                    return f;
                }
                return null;
            }

            private void addEntries(IModuleRelease mod) {
                if (this.norecur.contains(mod)) {
                    return;
                }
                this.norecur.add(mod);
                for (Scope s = Scope.TEST; s != null; s = s.getParent()) {
                    Collection sources = mod.getArtifacts(s, JDTProject.this.getSourceArtifactType());
                    for (File jar : mod.getArtifacts(s, JDTProject.this.getTargetArtifactType())) {
                        File sourcesZip = this.findSourcesArchive(sources, jar);
                        this.addEntry("lib", jar.getAbsolutePath(), sourcesZip, true);
                    }
                    for (IModuleRelease dep : mod.getDependencies(s)) {
                        this.addEntries(dep);
                    }
                }
            }

            private boolean addSrcEntry(String path) {
                if (!JDTProject.this.hasFile(path)) {
                    return false;
                }
                this.addEntry("src", path, null, true);
                return true;
            }

            private void addSrcEntries(String kind, Scope scope) throws Exception {
                String path = JDTProject.this.module.getSrcPath("gen".equals(kind), scope, JDTProject.this.getInputArtifactType());
                this.addSrcEntry(path);
            }

            private void addSrcEntries(Scope scope) throws Exception {
                this.addSrcEntries("src", scope);
                this.addSrcEntries("gen", scope);
            }

            public Object run() throws Exception {
                this.addSrcEntries(Scope.MAIN);
                this.addSrcEntries(Scope.POKE);
                this.addSrcEntries(Scope.TEST);
                this.addEntry("output", "bin", null, true);
                for (String s : JDTProject.this.listContainers()) {
                    this.addEntry("con", s, null, false);
                }
                for (IModuleProject mod : JDTProject.this.module.getWorkspaceDependencies(Scope.TEST)) {
                    this.addEntry("src", "/" + mod.getName(), null, true);
                }
                for (IModuleProject mod : JDTProject.this.module.getReleasedDependencies(Scope.TEST)) {
                    this.addEntries((IModuleRelease)mod);
                }
                for (Scope s = Scope.TEST; s != null; s = s.getParent()) {
                    Collection checkedArtifacts = JDTProject.this.module.getCheckedInArtifacts(s);
                    for (File a : checkedArtifacts) {
                        this.addEntry("lib", "checkedin/" + a.getName(), null, true);
                    }
                }
                return null;
            }
        }.run();
        StringTemplate template = JDTProject.getTemplate("classpath");
        template.setAttribute("entries", entries);
        this.writeFile(".classpath", template.toString());
    }

    private void generateDotSettings() throws Exception {
        File dir = this.getFile(".settings");
        if (!dir.isDirectory() && !dir.mkdir()) {
            throw new Error("Could not make .settings dir");
        }
        StringTemplate template = JDTProject.getTemplate("jdt_prefs");
        template.setAttribute("version", (Object)this.module.getJavaVersion());
        this.writeFile(".settings/org.eclipse.jdt.core.prefs", template.toString());
    }

    public void generate() throws Exception {
        this.contributeToDotProject();
        this.generateDotClasspath();
        this.generateDotSettings();
    }

    public String toString() {
        return "EclipseProject: " + this.module.getName();
    }

    private static StringTemplateGroup getTemplateGroup(String name) throws IOException {
        URL url = JDTProject.class.getResource(name);
        InputStream is = url.openStream();
        return new StringTemplateGroup((Reader)new InputStreamReader(is), DefaultTemplateLexer.class);
    }

    private static StringTemplate getTemplate(String name) throws IOException {
        return JDTProject.getTemplateGroup(name + ".stg").getInstanceOf(name);
    }

    public File getFile(String path) {
        return this.module.getProjectFile(path);
    }

    public boolean hasFile(String path) {
        return this.getFile(path).exists();
    }

    public void writeFile(String path, String contents) throws IOException {
        IOUtil.stringToFile((String)contents, (File)this.module.getProjectFile(path));
    }
}

