/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.java.compile;

import ebuild.ant.AntStuff;
import ebuild.api.IBuilderArgument;
import ebuild.api.IEBuild;
import ebuild.api.IModuleBuildProject;
import ebuild.api.IModuleRelease;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.selectors.FilenameSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavacRunner {
    final IBuilderArgument argument;
    final IEBuild ebuild;
    final ILogger logger;
    final IModuleBuildProject module;
    final Scope scope;

    public JavacRunner(IBuilderArgument argument) {
        this.argument = argument;
        this.ebuild = argument.getEBuild();
        this.logger = argument.getLogger();
        this.module = argument.getModuleBuildProject();
        this.scope = argument.getScope();
    }

    protected String getSourceType() {
        return "java";
    }

    protected String getFilenamePattern() {
        return "**/*.java";
    }

    private List<String> compilationSources() {
        List fs = this.argument.getInputDirs(this.getSourceType());
        ArrayList<String> r = new ArrayList<String>(fs.size());
        for (File f : fs) {
            r.add(f.getAbsolutePath());
        }
        return r;
    }

    public void buildClassPath(Collection<? extends IModuleRelease> deps, Scope scope, List<String> elements) {
        for (IModuleRelease iModuleRelease : deps) {
            this.buildClassPath(iModuleRelease, scope, elements);
        }
    }

    public void buildClassPath(IModuleRelease mod, Scope scope, List<String> elements) {
        for (Scope s = scope; s != null; s = s.getParent()) {
            for (File f : mod.getArtifacts(s, "java.classes.jar")) {
                elements.add(f.getAbsolutePath());
            }
        }
        this.buildClassPath(mod.getDependencies(scope), scope, elements);
    }

    public List<String> getClassPath(Scope scope) {
        ArrayList<String> elements = new ArrayList<String>();
        IModuleRelease release = this.module.getModuleRelease();
        for (Scope s = scope.getParent(); s != null; s = s.getParent()) {
            for (File f : release.getArtifacts(s, "java.classes.jar")) {
                elements.add(f.getAbsolutePath());
            }
        }
        for (File l : this.module.getCheckedInArtifacts(scope, "java.classes.jar")) {
            elements.add(l.getAbsolutePath());
        }
        this.buildClassPath(this.module.getReleasedDependencies(scope), scope, elements);
        return elements;
    }

    private String compilationClasspath() {
        List<String> classpathList = this.getClassPath(Scope.MAIN);
        this.logger.log("classpath: ");
        for (String s : classpathList) {
            this.logger.log("    " + this.ebuild.formatAsDisplayPath(new File(s)));
        }
        return StringUtil.join((String)";", classpathList);
    }

    private Path sourcePath(Project p, List<String> sources, boolean negate) {
        Path sourcePath = new Path(p);
        FilenameSelector fns = new FilenameSelector();
        fns.setName(this.getFilenamePattern());
        fns.setNegate(negate);
        for (String s : sources) {
            FileSet fs = new FileSet();
            fs.setDir(new File(s));
            fs.addFilename(fns);
            sourcePath.addFileset(fs);
        }
        return sourcePath;
    }

    public void doBuild() throws Exception {
        String nowarn = "-Xlint:-nocheck,-serial";
        File targetClasses = this.argument.getOutputDir("java.classes");
        List<String> sources = this.compilationSources();
        this.logger.log("sources: ");
        for (String s : sources) {
            this.logger.log("    " + this.ebuild.formatAsDisplayPath(new File(s)));
        }
        if (sources.size() > 0) {
            String classpath = this.compilationClasspath();
            Project p = new Project();
            p.setUserProperty("nowarn", nowarn);
            p.setUserProperty("output.debug", "true");
            p.setUserProperty("includeantruntime", "false");
            Path resourcePath = this.sourcePath(p, sources, true);
            Path sourcePath = this.sourcePath(p, sources, false);
            p.addReference("resource.path", (Object)resourcePath);
            p.addReference("source.path", (Object)sourcePath);
            p.setUserProperty("src.list", StringUtil.join((String)";", sources));
            p.setUserProperty("classpath", classpath);
            targetClasses.mkdirs();
            p.setUserProperty("target.classes", targetClasses.getAbsolutePath());
            AntStuff.Execution e = AntStuff.newExecution((Project)p, (ILogger)this.logger, (String)"build.xml", this.getClass());
            e.executeTarget("copy");
            e.executeTarget("compile");
        }
    }
}

