/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.java.jarmanifest;

import ebuild.ant.AntStuff;
import ebuild.api.IAssemblerArgument;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.BuildPluginException;
import ebuild.util.CollectionUtil;
import java.io.File;
import java.util.Collection;
import org.apache.tools.ant.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarManifestAssembler
extends AbstractAssembler {
    public Collection<File> assemble(IAssemblerArgument arg) throws BuildPluginException {
        String mainClass = (String)arg.getPropertyMap().get("Main-Class");
        File inputJar = arg.getInputMap().expectLoneInput().expectLoneArtifact();
        File outputDir = arg.getOutputDirectory();
        return CollectionUtil.singletonList((Object)this.addManifest(inputJar, mainClass, outputDir, arg.getLogger()));
    }

    public File addManifest(File inputJar, String mainClass, File outputDir, ILogger logger) throws BuildPluginException {
        Project p = new Project();
        String jarname = "manifested.jar";
        String mainclass = mainClass;
        p.setUserProperty("output.dir", outputDir.getAbsolutePath());
        p.setUserProperty("output.jar", jarname);
        if (mainclass != null) {
            p.setUserProperty("output.mainclass", mainclass);
        }
        p.setUserProperty("input.jar", inputJar.getAbsolutePath());
        try {
            AntStuff.newExecution((Project)p, (ILogger)logger, (String)"build.xml", ((Object)((Object)this)).getClass()).executeTarget("add-manifest");
        }
        catch (Exception e) {
            throw new BuildPluginException((Throwable)e);
        }
        return new File(outputDir, jarname);
    }
}

