/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.java.jarmerge;

import ebuild.ant.AntStuff;
import ebuild.api.IAssemblerArgument;
import ebuild.api.IInputMap;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.BuildPluginException;
import ebuild.util.CollectionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarMergeAssembler
extends AbstractAssembler {
    public static File combine(ILogger logger, File outputFile, Collection<File> inputJars) throws BuildPluginException {
        Project p = new Project();
        Path path = new Path(p);
        for (File f : inputJars) {
            Path.PathElement el = path.createPathElement();
            el.setLocation(f);
        }
        p.setUserProperty("output.dir", outputFile.getParentFile().getAbsolutePath());
        p.setUserProperty("output.jar", outputFile.getName());
        p.addReference("input.jars", (Object)path);
        try {
            AntStuff.newExecution((Project)p, (ILogger)logger, (String)"build.xml", JarMergeAssembler.class).executeTarget("combine");
        }
        catch (Exception e) {
            throw new BuildPluginException((Throwable)e);
        }
        return outputFile;
    }

    public Collection<File> assemble(IAssemblerArgument arg) throws BuildPluginException {
        ILogger logger = arg.getLogger();
        ArrayList<File> inputJars = new ArrayList<File>();
        IInputMap inputs = arg.getInputMap();
        logger.log("constituents: ");
        for (String name : inputs.inputKeys()) {
            Collection as = inputs.getInput(name).getArtifacts();
            for (File a : as) {
                if (!a.getName().endsWith(".jar")) continue;
                inputJars.add(a);
                logger.log("    " + arg.getEBuild().formatAsDisplayPath(a));
            }
        }
        String jarname = "combined.jar";
        File r = JarMergeAssembler.combine(logger, new File(arg.getOutputDirectory(), jarname), inputJars);
        return CollectionUtil.singletonList((Object)r);
    }
}

