/*
 * Decompiled with CFR 0.152.
 */
package org.vexi.build.shrink;

import ebuild.ant.AntStuff;
import ebuild.api.IAssemblerArgument;
import ebuild.api.IInput;
import ebuild.api.IInputMap;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import ebuild.util.OSUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.ProGuard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarShrinkAssembler
extends AbstractAssembler {
    private File getJavaLib() {
        File java_home = new File(System.getProperty("java.home"));
        if (OSUtil.isMacOSX()) {
            return new File(java_home, "../Classes/classes.jar");
        }
        return new File(java_home, "lib/rt.jar");
    }

    private void addToClassPath(ClassPath cp, File f, List<String> filter) {
        ClassPathEntry cpe = new ClassPathEntry(f, false);
        cpe.setFilter(filter);
        cp.add(cpe);
    }

    private void addToClassPath(ClassPath cp, Collection<File> in) {
        for (File f : in) {
            this.addToClassPath(cp, f, CollectionUtil.singletonList((Object)"!META-INF/MANIFEST.MF"));
        }
    }

    public Collection<File> assemble(IAssemblerArgument argument) throws BuildPluginException {
        ILogger logger = argument.getLogger();
        IPropertyMap props = argument.getPropertyMap();
        IInputMap inputs = argument.getInputMap();
        Collection shrinkJars = inputs.expectInput("shrink").getArtifacts();
        IInput preserveInput = inputs.getInput("preserve");
        Collection<File> preserveJars = preserveInput != null ? preserveInput.getArtifacts() : CollectionUtil.EMPTY_LIST;
        IInput libraryInput = inputs.getInput("library");
        Collection<File> libraryJars = libraryInput != null ? libraryInput.getArtifacts() : CollectionUtil.EMPTY_LIST;
        shrinkJars.removeAll(preserveJars);
        shrinkJars.removeAll(libraryJars);
        logger.log("shrink:");
        for (File f : shrinkJars) {
            logger.log("    " + f.getAbsolutePath());
        }
        logger.log("preserve:");
        for (File f : preserveJars) {
            logger.log("    " + f.getAbsolutePath());
        }
        logger.log("library:");
        for (File f : libraryJars) {
            logger.log("    " + f.getAbsolutePath());
        }
        File shrinkOutputJar = new File(argument.getOutputDirectory(), "shrunk.jar");
        ClassPath programJarsPath = new ClassPath();
        this.addToClassPath(programJarsPath, shrinkJars);
        programJarsPath.add(new ClassPathEntry(shrinkOutputJar, true));
        ClassPath libraryJarsPath = new ClassPath();
        this.addToClassPath(libraryJarsPath, preserveJars);
        this.addToClassPath(libraryJarsPath, libraryJars);
        this.addToClassPath(libraryJarsPath, this.getJavaLib(), CollectionUtil.newList((Object[])new String[]{"!META-INF/MANIFEST.MF,java/**,javax/**"}));
        Configuration conf = new Configuration();
        conf.programJars = programJarsPath;
        conf.libraryJars = libraryJarsPath;
        if (FileUtil.lastModified((Collection)shrinkJars) > shrinkOutputJar.lastModified()) {
            String proguard_options = props.getString("proguard_options", "");
            logger.log("Shrinking with proguard");
            ILogger pgLogger = logger.newSubLogger("ProGuard");
            pgLogger.prime();
            ProGuard pg = new ProGuard(conf);
            try {
                File temp = File.createTempFile("proguard_options", "tmp");
                IOUtil.stringToFile((String)proguard_options, (File)temp);
                ConfigurationParser p = new ConfigurationParser(temp);
                p.parse(conf);
                pg.execute();
            }
            catch (Exception e) {
                throw new BuildPluginException((Throwable)e);
            }
        } else {
            logger.log("SKIPPING shrink - up to date");
        }
        if (preserveJars.size() == 0) {
            return CollectionUtil.singletonList((Object)shrinkOutputJar);
        }
        ArrayList<File> path = new ArrayList<File>(preserveJars.size() + 1);
        path.addAll(preserveJars);
        path.add(shrinkOutputJar);
        File combined = new File(argument.getOutputDirectory(), "combined.jar");
        if (FileUtil.lastModified(path) > combined.lastModified()) {
            logger.log("Combining preserved jars, with shrink output");
            JarShrinkAssembler.combine(logger, combined, path);
        } else {
            logger.log("SKIPPING combine - up to date");
        }
        return CollectionUtil.singletonList((Object)combined);
    }

    public static File combine(ILogger logger, File outputFile, Collection<File> inputJars) throws BuildPluginException {
        Project p = new Project();
        Path path = new Path(p);
        for (File f : inputJars) {
            Path.PathElement el = path.createPathElement();
            el.setLocation(f);
        }
        p.setUserProperty("output.dir", outputFile.getParentFile().getAbsolutePath());
        p.setUserProperty("output.jar", outputFile.getName());
        p.addReference("input.jars", (Object)path);
        try {
            AntStuff.newExecution((Project)p, (ILogger)logger, (String)"build.xml", JarShrinkAssembler.class).executeTarget("combine");
        }
        catch (Exception e) {
            throw new BuildPluginException((Throwable)e);
        }
        return outputFile;
    }
}

