/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.java.jarsign;

import ebuild.ant.AntStuff;
import ebuild.api.IAssemblerArgument;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.util.CollectionUtil;
import ebuild.util.IOUtil;
import ebuild.util.JSONUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.apache.tools.ant.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarSignAssembler
extends AbstractAssembler {
    public Collection<File> assemble(IAssemblerArgument arg) throws BuildPluginException {
        try {
            IPropertyMap props = arg.getPropertyMap();
            String key = props.expectString("key");
            File passwordFile = arg.getEBuild().getCredentialsFile("jarsigner.passwords");
            Map passwordJson = JSONUtil.readMap((String)IOUtil.fileToString((File)passwordFile));
            Map passwordsOfKeystores = (Map)passwordJson.get("keystores");
            Map passwordsOfKeys = (Map)passwordJson.get("keys");
            String storepass = (String)passwordsOfKeystores.get("_default");
            String keypass = (String)passwordsOfKeys.get(key);
            File inputJar = arg.getInputMap().expectLoneInput().expectLoneArtifact();
            File outputJar = new File(arg.getOutputDirectory(), "signed.jar");
            Project p = new Project();
            p.setUserProperty("signee", inputJar.getAbsolutePath());
            p.setUserProperty("signed", outputJar.getAbsolutePath());
            p.setUserProperty("storepass", storepass);
            p.setUserProperty("key", key);
            p.setUserProperty("keypass", keypass);
            AntStuff.newExecution((Project)p, (ILogger)arg.getLogger(), (String)"build.xml", ((Object)((Object)this)).getClass()).executeTarget("sign");
            return CollectionUtil.singletonList((Object)outputJar);
        }
        catch (Exception e) {
            throw BuildPluginException.wrap((Exception)e);
        }
    }
}

