/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.javacc;

import ebuild.api.IBuilderArgument;
import ebuild.api.IEBuild;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.plugin.BuildPluginException;
import ebuild.util.FileUtil;
import java.io.File;
import org.javacc.parser.Main;

public class JavaCCBuilder
extends AbstractBuilder {
    public void build(IBuilderArgument argument) throws BuildPluginException {
        final IEBuild ebuild = argument.getEBuild();
        final ILogger logger = argument.getLogger();
        final File genDir = argument.getOutputArtifact("java", false);
        try {
            final String argsProp = argument.getPropertyMap().getString("args", "").trim();
            for (final File srcDir : argument.getInputDirs("javacc")) {
                new FileUtil.Traversal(){

                    public void onFile(File in) throws Exception {
                        if (in.isDirectory()) {
                            return;
                        }
                        String fileName = in.getName();
                        if (fileName.endsWith(".jj")) {
                            File srcParent = in.getParentFile();
                            String relativePath = FileUtil.relativePath2Child((File)srcDir, (File)srcParent);
                            File out = new File(genDir, relativePath);
                            String argsString = String.valueOf(argsProp) + " -OUTPUT_DIRECTORY=" + out.getCanonicalPath() + " " + in.getCanonicalPath();
                            logger.log("   .jj  " + in.getCanonicalPath());
                            String[] args = argsString.trim().split(" ");
                            logger.log("arguments:");
                            String[] stringArray = args;
                            int n = args.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String a = stringArray[n2];
                                logger.log("    " + a);
                                ++n2;
                            }
                            Main.mainProgram((String[])args);
                        } else {
                            logger.log("[WARNING] ignoring non .jj file: " + ebuild.formatAsDisplayPath(in));
                        }
                    }
                }.go(srcDir);
            }
        }
        catch (Exception e) {
            throw new BuildPluginException((Throwable)e);
        }
    }
}

