package ebuild.build.java.javadoc;


import static ebuild.util.CollectionUtil.singletonList;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.sun.tools.javadoc.Main;

import ebuild.api.IAssemblerArgument;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.BuildPluginException;
import ebuild.util.FileUtil;
import ebuild.util.ZipUtil;

public class JavaDocAssembler extends AbstractAssembler{

	private void listPackages(Set<String> ps, String p, File f) {
		String fname = f.getName();
		if(fname.startsWith(".")) return;
		
		if(f.isDirectory()){
			for(File f2: f.listFiles()){
				if(f2.getName().startsWith(".")) continue;
				String p2 = (p==null?"":p+".")+fname;
				listPackages(ps, p2, f2);
			}
		}else{
			if(fname.endsWith(".java")){
				ps.add(p);
			}
		}
	}
	
	private Set<String> listPackages(File dir) {
		Set<String> r = new HashSet();
		for(File f: dir.listFiles()){
			listPackages(r, null, f);
		}
		return r;
	}
	
	
    public Collection<File> assemble(IAssemblerArgument arg) throws BuildPluginException {
        try{
        	File javaDir = new File(arg.getOutputDirectory(), "java");
        	File javadocDir = new File(arg.getOutputDirectory(), "javadoc");
        	javaDir.mkdirs();
        	javadocDir.mkdirs();
        	
        	Collection<File> javaSources = arg.getInputMap().expectLoneInput().getArtifacts();
        	for(File a: javaSources){
        		if(a.isFile()){
        			ZipUtil.unzipArchive(a, javaDir);
        		}else{
        			FileUtil.copy(a, javaDir);
        		}
        	}
        	
        	
        	Set<String> packages = listPackages(javaDir);
        	
        	List<String> args = new ArrayList(4+packages.size());
        	
        	args.add("-d"); args.add(FileUtil.canonicalFile(javadocDir).getPath());
        	
        	args.add("-sourcepath");
        	args.add(FileUtil.canonicalFile(javaDir).getPath());
        	for(String p: packages) args.add(p);
        	
        	ILogger logger = arg.getLogger();
        	logger.log("Javadoc Args");
        	for(String a: args){
        		logger.log("    "+a);
        	}
        	String[] argsArray = args.toArray(new String[args.size()]);
        	
        	Main.execute(argsArray);
    		
            return singletonList(javadocDir);
        }catch(IOException e){
            throw new BuildPluginException(e);
        }

    }
}
