/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.java.remap;

import ebuild.api.IBuilderArgument;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.BuildPluginException;
import ebuild.build.java.compile.JavaBuilder;
import ebuild.lib.remap.RemapReport;
import ebuild.lib.remap.RemappingUtil;
import ebuild.util.FileUtil;
import ebuild.util.JSONUtil;
import ebuild.util.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.objectweb.asm.commons.Remapper;

public class RemapBuilder
extends JavaBuilder {
    private String generateMappingInfo(CompleteRemap.PackageRemap pr, File targetClasses) throws IOException {
        String path = pr.packageAfter + "/remap.json";
        File f = new File(targetClasses, path);
        FileWriter fw = new FileWriter(f);
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put("package-before", pr.packageBefore);
        obj.put("classes", pr.classes);
        JSONUtil.writeObject((Writer)fw, obj);
        fw.close();
        return path;
    }

    public void build(IBuilderArgument arg) throws BuildPluginException {
        super.build(arg);
        ILogger logger = arg.getLogger();
        String mapProp = arg.getPropertyMap().getString("map");
        if (mapProp != null) {
            File targetClasses = arg.getOutputDir("java.classes");
            final CompleteRemap remap = new CompleteRemap(mapProp, targetClasses);
            Remapper remapper = new Remapper(){

                public String map(String t) {
                    String r = remap.map.get(t);
                    if (r == null) {
                        return t;
                    }
                    return r;
                }
            };
            File targetClasses0 = new File(targetClasses.getParentFile(), targetClasses.getName() + "-unmapped");
            try {
                FileUtil.moveDir((File)targetClasses, (File)targetClasses0);
                logger.log("remapping: ");
                RemapReport report = RemappingUtil.remapDir((Remapper)remapper, (File)targetClasses0, (File)targetClasses);
                for (String from : report.remapped.keySet()) {
                    String to = (String)report.remapped.get(from);
                    logger.log("    " + from);
                    logger.log(" -> " + to);
                }
                if (report.shouldHaveBeenMapped.size() > 0) {
                    throw new BuildPluginException("Classes have changed references but not remapped:" + StringUtil.prefix((String)"\n    ", (Collection)report.shouldHaveBeenMapped));
                }
                logger.log("remapping info: ");
                for (CompleteRemap.PackageRemap pr : remap.packages) {
                    String path = this.generateMappingInfo(pr, targetClasses);
                    logger.log("    " + path);
                }
            }
            catch (IOException e) {
                throw new BuildPluginException((Throwable)e);
            }
        }
    }

    private static class CompleteRemap {
        final Map<String, String> map = new TreeMap<String, String>();
        List<PackageRemap> packages = new LinkedList<PackageRemap>();

        CompleteRemap(String mapProp, File targetClasses) {
            List list = JSONUtil.readList((String)mapProp);
            for (Map m : list) {
                String packageBefore = ((String)m.get("package-before")).replace('.', '/');
                String packageAfter = ((String)m.get("package-after")).replace('.', '/');
                PackageRemap pr = new PackageRemap(packageBefore, packageAfter);
                if (m.containsKey("classes")) {
                    List classes = (List)m.get("classes");
                    for (String c : classes) {
                        pr.add(c);
                    }
                } else {
                    String[] classFiles;
                    File packageDir = new File(targetClasses, packageBefore);
                    for (String cf : classFiles = packageDir.list(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".class");
                        }
                    })) {
                        String c = FileUtil.removeSuffix((String)cf);
                        pr.add(c);
                    }
                }
                this.packages.add(pr);
            }
        }

        class PackageRemap {
            final String packageBefore;
            final String packageAfter;
            final Collection<String> classes = new TreeSet<String>();

            PackageRemap(String packageBefore, String packageAfter) {
                this.packageBefore = packageBefore;
                this.packageAfter = packageAfter;
            }

            public void add(String c) {
                String classBefore = this.packageBefore + "/" + c;
                String classAfter = this.packageAfter + "/" + c;
                CompleteRemap.this.map.put(classBefore, classAfter);
                this.classes.add(c);
            }
        }
    }
}

