/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.java.versionclass;

import ebuild.api.IBuilderArgument;
import ebuild.api.IModuleBuildProject;
import ebuild.api.common.IVersion;
import ebuild.api.common.Scope;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class VersionClassBuilder
extends AbstractBuilder {
    private String defaultPackage(IModuleBuildProject moduleBuildProject) {
        return moduleBuildProject.getName().replace('-', '.');
    }

    public void build(IBuilderArgument arg) throws BuildPluginException {
        if (arg.getScope() != Scope.MAIN) {
            return;
        }
        IModuleBuildProject module = arg.getModuleBuildProject();
        IPropertyMap props = arg.getPropertyMap();
        String package_ = props.getString("package", this.defaultPackage(module));
        String classname = props.getString("classname", "ModuleVersion");
        IVersion versionObj = module.getVersion();
        File dirRoot = arg.getOutputArtifact("java", false);
        File dirPackage = new File(dirRoot, package_.replace('.', '/'));
        dirPackage.mkdirs();
        try {
            PrintWriter out = new PrintWriter(new File(dirPackage, String.valueOf(classname) + ".java"));
            out.println("package " + package_ + ";");
            out.println("public class " + classname + "{");
            out.println("    static final public String TAG =" + this.printString(versionObj.getTag()) + ";");
            out.println("    static final public String BRANCH =" + this.printString(versionObj.getBranch()) + ";");
            out.println("    static final public String REVISION =" + this.printString(versionObj.getRevision()) + ";");
            out.println("    static final public String STRING =" + this.printString(versionObj.toString()) + ";");
            out.println("}");
            out.close();
        }
        catch (IOException e) {
            throw new BuildPluginException((Throwable)e);
        }
    }

    private String printString(String v) {
        if (v == null) {
            return "null";
        }
        return "\"" + v + "\"";
    }
}

