/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.simplexml.doc;

import ebuild.api.IAssemblerArgument;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.util.CollectionUtil;
import ebuild.util.JSONUtil;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.simpleframework.xml.doc.SimpleXmlDoc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXmlDocAssembler
extends AbstractAssembler {
    public Collection<File> assemble(IAssemblerArgument arg) throws BuildPluginException {
        try {
            IPropertyMap props = arg.getPropertyMap();
            File docletExportFile = new File(arg.getOutputDirectory(), "serialised_doclet");
            File outputDir = new File(arg.getOutputDirectory(), "xmldoc");
            outputDir.mkdirs();
            docletExportFile.mkdirs();
            Collection inputSourcePath = arg.getInputMap().expectInput("sources").getArtifacts();
            Collection inputClassPath = arg.getInputMap().expectInput("classes").getArtifacts();
            String aboutClass = props.expectString("about-class");
            Map rootClasses = JSONUtil.readMap((String)props.expectString("root-classes"));
            URLClassLoader ucl = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
            URL[] urls = ucl.getURLs();
            ArrayList<File> docletPath = new ArrayList<File>(urls.length);
            for (URL url : urls) {
                docletPath.add(new File(url.getPath()));
            }
            SimpleXmlDoc.run(inputSourcePath, inputClassPath, aboutClass, rootClasses, outputDir, docletExportFile, docletPath);
            return CollectionUtil.singletonList((Object)outputDir);
        }
        catch (Exception e) {
            throw new BuildPluginException((Throwable)e);
        }
    }
}

