/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import ebuild.lib.doclet.DocExport;
import ebuild.lib.doclet.ExportDocletRunner;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.util.ObjectUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simpleframework.xml.core.DocHelper;
import org.simpleframework.xml.core.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocModel {
    private final ExportDocletRunner docletRunner;
    public final Map<ElementKey, Element> elements = new LinkedHashMap<ElementKey, Element>();

    public DocModel(ExportDocletRunner docletRunner) {
        this.docletRunner = docletRunner;
    }

    public List<Element> listShared() throws Exception {
        ArrayList<Element> r = new ArrayList<Element>();
        for (Element el : this.elements.values()) {
            if (el.isExclusive()) continue;
            r.add(el);
        }
        return r;
    }

    public Element buildModel(Class rootClass) throws Exception {
        String name = DocHelper.style.getAttribute(rootClass.getSimpleName());
        return this.getElement(new ElementKey(name, rootClass));
    }

    Element getElement(ElementKey key) throws Exception {
        Element r = this.elements.get(key);
        if (r == null) {
            DocExport.Class doc = this.docletRunner.expectClassDoc(key.class_);
            String html = "";
            String group = "";
            if (doc != null) {
                html = doc.commentText;
                group = doc.getTagText("@group");
            }
            r = new Element(key, html);
            if (!"".equals(group)) {
                r.group = group;
            }
            this.elements.put(key, r);
            this.recurseElement(r, doc);
        }
        return r;
    }

    public void recurseElement(Element element, DocExport.Class classDoc) throws Exception {
        System.err.println("Doing " + element.getName());
        DocHelper helper = new DocHelper(element.getType(), classDoc);
        List fds = classDoc.getAllFields();
        for (DocExport.Field fd : fds) {
            ElementRef el;
            String field = fd.name;
            Label label = helper.getAttribute(field);
            if (label != null) {
                Attribute attr = DocModel.newAttributeModel(fd, label);
                element.attributes.add(attr);
                continue;
            }
            if (helper.inline.containsKey((Object)field)) {
                label = (Label)helper.inline.get((Object)field);
                if (label == null) continue;
                Class c = label.getDependent().getType();
                String entry = label.getEntry();
                ElementRef el2 = this.newElementRef(element, fd, label, c, entry);
                element.add(el2);
                continue;
            }
            label = helper.getElement(field);
            if (label == null) continue;
            if (label.isCollection()) {
                el = this.newListElementRef(element, fd, label);
            } else {
                Class c = label.getType();
                el = this.newElementRef(element, fd, label, c);
            }
            element.add(el);
        }
    }

    ElementRef newElementRef(Element parent, DocExport.Field fieldDoc, Label label, Class class_) throws Exception {
        return this.newElementRef(parent, fieldDoc, label, class_, label.getName());
    }

    ElementRef newElementRef(Element parent, DocExport.Field fieldDoc, Label label, Class class_, String elementName) throws Exception {
        String name = DocHelper.style.getElement(elementName);
        String cardinality = DocModel.getCardinality(label);
        ElementKey toKey = new ElementKey(name, class_);
        Element to = this.getElement(toKey);
        return new ElementRef(parent, to, cardinality, fieldDoc.commentText);
    }

    ElementRef newListElementRef(Element parent, DocExport.Field fieldDoc, Label label) throws Exception {
        String name = DocHelper.style.getElement(label.getName());
        String entry = DocHelper.style.getElement(label.getEntry());
        Class c = label.getDependent().getType();
        ElementKey listKey = new ElementKey(name, c);
        Element listEl = new Element(listKey, "");
        ElementRef listRef = new ElementRef(parent, listEl, DocModel.getCardinality(label), fieldDoc.commentText);
        this.elements.put(listKey, listEl);
        System.err.println("Doing " + listEl.getName());
        ElementKey childKey = new ElementKey(entry, c);
        Element childEl = this.getElement(childKey);
        ElementRef childRef = new ElementRef(listEl, childEl, "0..n", "Child elements");
        listEl.add(childRef);
        return listRef;
    }

    public static Attribute newAttributeModel(DocExport.Field fieldDoc, Label label) throws Exception {
        String name = DocHelper.style.getAttribute(label.getName());
        String req = label.isRequired() ? "yes" : "no";
        return new Attribute(name, req, fieldDoc.commentText);
    }

    private static String getCardinality(Label label) {
        if (label.isCollection() && label.isInline()) {
            return "0..n";
        }
        if (label.isRequired()) {
            return "1";
        }
        return "0..1";
    }

    public static class About {
        public final String title;
        public final String version;
        public final String body;

        public About(String title, String version, String body) {
            this.title = title;
            this.version = version;
            this.body = body;
        }

        public String getTitle() {
            return this.title;
        }

        public String getVersion() {
            return this.version;
        }

        public String getBody() {
            return this.body;
        }
    }

    public static class Attribute {
        public final String name;
        public final String required;
        public final String html;

        public Attribute(String name, String required, String html) {
            this.name = name;
            this.required = required;
            this.html = html;
        }

        public String getName() {
            return this.name;
        }

        public String getRequired() {
            return this.required;
        }

        public String getDescription() {
            return this.html;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Element {
        final List<ElementRef> parentRefs = new ArrayList<ElementRef>(2);
        final ElementKey key;
        final String html;
        final List<Attribute> attributes = new ArrayList<Attribute>();
        final List<ElementRef> childRefs = new ArrayList<ElementRef>();
        String group = null;

        Element(ElementKey key, String html) {
            this.key = key;
            this.html = html;
        }

        void add(ElementRef child) {
            this.childRefs.add(child);
        }

        public boolean isHasGroup() {
            return !this.isExclusive() && this.group != null;
        }

        public boolean isHasAttributes() {
            return this.attributes.size() > 0;
        }

        public boolean isHasChildren() {
            return this.childRefs.size() > 0;
        }

        public boolean isIsRoot() {
            return this.parentRefs.size() == 0;
        }

        public List<Element> getParents() {
            ArrayList<Element> r = new ArrayList<Element>(this.parentRefs.size());
            for (ElementRef ref : this.parentRefs) {
                r.add(ref.from);
            }
            return r;
        }

        public String getDoc() {
            return this.html;
        }

        public String getName() {
            return this.key.name;
        }

        public Class getType() {
            return this.key.class_;
        }

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        public List<ElementRef> getChildRefs() {
            return this.childRefs;
        }

        public List<Element> getChildren(boolean top) {
            if (top || this.isExclusive()) {
                ArrayList<Element> r = new ArrayList<Element>(this.childRefs.size());
                for (ElementRef ref : this.childRefs) {
                    Element to = ref.to;
                    if (to.isHasGroup()) continue;
                    r.add(to);
                }
                return r;
            }
            return CollectionUtil.EMPTY_LIST;
        }

        public Set<String> getChildGroups() {
            HashSet<String> r = new HashSet<String>();
            for (ElementRef ref : this.childRefs) {
                Element to = ref.to;
                if (!to.isHasGroup()) continue;
                r.add(to.getGroup());
            }
            return r;
        }

        public List<Element> getChildren() {
            return this.getChildren(true);
        }

        public List<Element> getChildrenExclusive() {
            return this.getChildren(false);
        }

        public String getGroup() {
            if (this.isIsRoot()) {
                return "Root";
            }
            if (this.group == null) {
                return "Other Repeated Elements";
            }
            return this.group;
        }

        public boolean isShared() {
            return this.parentRefs.size() > 1;
        }

        public boolean isExclusive() {
            return this.parentRefs.size() == 1;
        }

        public int depth() {
            if (this.isExclusive()) {
                return 1 + this.parentRefs.get((int)0).from.depth();
            }
            return 0;
        }

        String getPath() {
            if (this.isExclusive()) {
                return String.valueOf(this.parentRefs.get((int)0).from.getPath()) + "->" + this.getName();
            }
            return this.getName();
        }

        public String getIndent() {
            String r = "";
            int i = this.depth();
            while (i > 0) {
                r = String.valueOf(r) + "&nbsp;&nbsp;";
                --i;
            }
            return r;
        }

        public String getFileName() {
            if (this.isExclusive()) {
                return String.valueOf(this.parentRefs.get((int)0).from.getFileName()) + "--" + this.getName();
            }
            return this.getName();
        }

        public String toString() {
            return this.getPath();
        }

        public boolean isDull() {
            return this.key.class_ == null;
        }
    }

    public static class ElementKey {
        final String name;
        final Class class_;

        ElementKey(String name, Class class_) {
            this.name = name;
            this.class_ = class_;
        }

        public int hashCode() {
            return ObjectUtil.hashOf((Object)this.name) + ObjectUtil.hashOf((Object)this.class_);
        }

        public boolean equals(Object o) {
            ElementKey b = (ElementKey)o;
            return ObjectUtil.areEqual((Object)this.name, (Object)b.name) && ObjectUtil.areEqual((Object)this.class_, (Object)b.class_);
        }

        public String toString() {
            return "<" + this.name + "/>:" + this.class_;
        }
    }

    public static class ElementRef {
        public final Element from;
        public final Element to;
        public final String cardinality;
        public final String html;

        ElementRef(Element from, Element to, String cardinality, String html) {
            this.from = from;
            this.to = to;
            this.cardinality = cardinality;
            this.html = html;
            to.parentRefs.add(this);
        }

        public String getName() {
            return this.to.getName();
        }

        public String getCardinality() {
            return this.cardinality;
        }

        public String getDescription() {
            return this.html;
        }
    }

    public static class File {
        public final String name;
        public final Class rootClass;

        public File(String name, Class rootClass) {
            this.name = name;
            this.rootClass = rootClass;
        }

        public String getFileName() {
            return this.name;
        }

        public String getDirName() {
            return FileUtil.removeSuffix((String)this.name);
        }

        public String getContentsFile() {
            return String.valueOf(this.getDirName()) + "/contents.html";
        }
    }
}

