/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.doc;

import ebuild.build.simplexml.doc.SimpleXmlDocAssembler;
import ebuild.lib.doclet.ExportDocletRunner;
import ebuild.util.CollectionUtil;
import ebuild.util.IOUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.simpleframework.xml.core.DocModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXmlDoc {
    private final List<DocModel.File> roots = new ArrayList<DocModel.File>();
    private final ExportDocletRunner docletRunner;
    private final File outDir;
    private Class aboutClass;
    private String title;
    private String version;

    public static void run(Collection<File> inputSourcePath, Collection<File> inputClassPath, String aboutClass, Map<String, String> rootClasses, File outputDir, File docletExportFile, Collection<File> docletPath) throws Exception {
        ClassLoader inputClassLoader = SimpleXmlDoc.getClassLoader(inputClassPath);
        ExportDocletRunner export = new ExportDocletRunner().setSourcepath(inputSourcePath).setClasspath(inputClassPath).setOutDir(outputDir);
        if (docletPath != null) {
            export.setDocletpath(docletPath);
        }
        SimpleXmlDoc xmlDoc = new SimpleXmlDoc(export, outputDir).setAboutClass(inputClassLoader.loadClass(aboutClass));
        for (String k : rootClasses.keySet()) {
            xmlDoc.addRoot(k, inputClassLoader.loadClass(rootClasses.get(k)));
        }
        xmlDoc.run();
    }

    public static ClassLoader getClassLoader(Collection<File> files) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        for (File f : files) {
            if (f.getName().startsWith("simple-xml")) continue;
            urls.add(f.toURI().toURL());
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), SimpleXmlDocAssembler.class.getClassLoader());
    }

    public SimpleXmlDoc(ExportDocletRunner docletRunner, File outDir) {
        this.docletRunner = docletRunner;
        this.outDir = outDir;
    }

    public SimpleXmlDoc setTitle(String title) {
        this.title = title;
        return this;
    }

    public SimpleXmlDoc setVersion(String version) {
        this.version = version;
        return this;
    }

    public SimpleXmlDoc setAboutClass(Class aboutClass) {
        this.aboutClass = aboutClass;
        return this;
    }

    public SimpleXmlDoc addRoot(String filename, Class rootClass) {
        this.roots.add(new DocModel.File(filename, rootClass));
        return this;
    }

    public void run() throws Exception {
        this.copy("toc.css");
        this.copy("table.css");
        this.generateAbout();
        this.generateIndex();
        this.generateFileList();
        for (DocModel.File f : this.roots) {
            this.generate(f);
        }
    }

    private void generateAbout() throws Exception {
        StringTemplate t = SimpleXmlDoc.getTemplate("about.stg", "about");
        t.setAttribute("title", (Object)this.title);
        t.setAttribute("version", (Object)this.version);
        t.setAttribute("body", (Object)this.docletRunner.expectClassDoc((Class)this.aboutClass).commentText);
        File index_html = new File(this.outDir, "about.html");
        IOUtil.stringToFile((String)("" + t), (File)index_html);
    }

    private void generateIndex() throws Exception {
        StringTemplate t = SimpleXmlDoc.getTemplate("index.stg", "index");
        t.setAttribute("title", (Object)"Xml Doc");
        File index_html = new File(this.outDir, "index.html");
        IOUtil.stringToFile((String)("" + t), (File)index_html);
    }

    private void generateFileList() throws Exception {
        StringTemplate t = SimpleXmlDoc.getTemplate("filelist.stg", "filelist");
        t.setAttribute("files", this.roots);
        File index_html = new File(this.outDir, "filelist.html");
        IOUtil.stringToFile((String)("" + t), (File)index_html);
    }

    private void generate(DocModel.File fileModel) throws Exception {
        String fileName = fileModel.name;
        Class rootClass = fileModel.rootClass;
        System.err.println("--- Documenting Schema : " + fileName + " ---");
        File dir = new File(this.outDir, fileModel.getDirName());
        dir.mkdirs();
        DocModel model = new DocModel(this.docletRunner);
        DocModel.Element el = model.buildModel(rootClass);
        el.getName();
        LinkedHashMap<String, List<DocModel.Element>> contentsModel = new LinkedHashMap<String, List<DocModel.Element>>();
        List<DocModel.Element> shared = model.listShared();
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        for (DocModel.Element e : shared) {
            groups.add(e.getGroup());
        }
        for (String g : groups) {
            contentsModel.put(g, new ArrayList());
        }
        for (DocModel.Element e : shared) {
            ((List)contentsModel.get(e.getGroup())).add(e);
        }
        String body = this.writeContents(contentsModel);
        StringTemplate t = SimpleXmlDoc.getTemplate("contents.stg", "contents");
        t.setAttribute("filename", (Object)fileName);
        t.setAttribute("body", (Object)body);
        File index_html = new File(dir, "contents.html");
        IOUtil.stringToFile((String)("" + t), (File)index_html);
        for (DocModel.Element e : model.elements.values()) {
            StringTemplate t2 = SimpleXmlDoc.getTemplate("page.stg", "page");
            t2.setAttribute("element", (Object)e);
            File fout = new File(dir, String.valueOf(e.getFileName()) + ".html");
            IOUtil.stringToFile((String)("" + t2), (File)fout);
        }
    }

    private void writeChildren(StringBuilder sb, String indent, List<DocModel.Element> es, Collection<String> groups, boolean top) {
        sb.append(String.valueOf(indent) + "<ul>\n");
        for (String g : groups) {
            sb.append(String.valueOf(indent) + "<li>\n");
            sb.append(String.valueOf(indent) + "  <i>" + g + "</i>\n");
            sb.append(String.valueOf(indent) + "</li>\n");
        }
        for (DocModel.Element e : es) {
            this.writeElement(sb, String.valueOf(indent) + "  ", e, top);
        }
        sb.append(String.valueOf(indent) + "</ul>\n");
    }

    private void writeElement(StringBuilder sb, String indent, DocModel.Element el, boolean top) {
        boolean isTruncated = !top && !el.isExclusive();
        String text = "<span class='toctext'>" + el.getName() + (isTruncated ? "..." : "") + "</span>";
        text = "<a href='./" + el.getFileName() + ".html' target='main'>" + text + "</a>";
        sb.append(String.valueOf(indent) + "<li>\n");
        sb.append(String.valueOf(indent) + "  " + text + "\n");
        this.writeChildren(sb, String.valueOf(indent) + "  ", el.getChildren(top), el.getChildGroups(), false);
        sb.append(String.valueOf(indent) + "</li>\n");
    }

    public String writeContents(Map<String, List<DocModel.Element>> groups) {
        StringBuilder sb = new StringBuilder(1024);
        for (String group : groups.keySet()) {
            List<DocModel.Element> vals = groups.get(group);
            sb.append("<div class='toctitle'><h2>" + group + "</h2></div>\n");
            this.writeChildren(sb, "", vals, CollectionUtil.EMPTY_LIST, true);
        }
        return sb.toString();
    }

    public static void printcl(ClassLoader cl) {
        System.err.println(String.valueOf(cl.hashCode()) + " " + cl + " " + cl.getClass());
    }

    public static void printcl(Class c) {
        SimpleXmlDoc.printcl(c.getClassLoader());
    }

    private static StringTemplateGroup getTemplateGroup(String name) throws Exception {
        URL url = SimpleXmlDoc.class.getResource(name);
        InputStream is = url.openStream();
        return new StringTemplateGroup((Reader)new InputStreamReader(is), DefaultTemplateLexer.class);
    }

    private static StringTemplate getTemplate(String file, String name) throws Exception {
        return SimpleXmlDoc.getTemplateGroup(file).getInstanceOf(name);
    }

    public OutputStream getOutputStream(String path) throws IOException {
        File f = new File(this.outDir, path);
        f.getParentFile().mkdirs();
        return new FileOutputStream(f);
    }

    public InputStream source(String resource) throws IOException {
        URL resourceURL = SimpleXmlDoc.class.getResource(resource);
        if (resourceURL == null) {
            throw new IOException("No such file: " + resource);
        }
        return resourceURL.openStream();
    }

    public void copy(String fileName) throws IOException {
        System.err.println("Copying : " + fileName);
        this.copy(fileName, fileName);
    }

    public void copy(String from, String to) throws IOException {
        InputStream in = this.source(from);
        OutputStream out = this.getOutputStream(to);
        IOUtil.pipe((InputStream)in, (OutputStream)out);
    }
}

