/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.site;

import ebuild.api.plugin.BuildPluginException;
import ebuild.build.site.Model;
import ebuild.build.site.xml.NavigationXml;
import ebuild.build.site.xml.NewsXml;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import ebuild.util.JSONUtil;
import ebuild.util.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.eclipse.mylyn.wikitext.confluence.core.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;
import org.eclipse.mylyn.wikitext.tracwiki.core.TracWikiLanguage;
import org.eclipse.mylyn.wikitext.twiki.core.TWikiLanguage;

public class SiteBuildRunner {
    final SourcePath path;
    final File outDir;
    private StringTemplateGroup templates;
    private Map<String, String> vars;
    private List<NavigationXml.Link> navigation;

    public SiteBuildRunner(File outDir, File ... sources) throws Exception {
        this.path = new SourcePath(sources);
        this.outDir = outDir;
    }

    private String insertVars(String html) {
        for (String name : this.vars.keySet()) {
            String value = this.vars.get(name);
            html = html.replace("<!--" + name + "-->", value);
        }
        return html;
    }

    void generateFile(Model.Page model) throws IOException {
        SiteBuildRunner.log("Generating page", "->", model.getPath());
        String templateName = model.getTemplate("single_col");
        StringTemplate template = this.templates.getInstanceOf(templateName);
        template.setAttribute("page", (Object)model);
        String outHtml = this.insertVars(template + "");
        File out = new File(this.outDir, model.getPath());
        out.getParentFile().mkdirs();
        IOUtil.stringToFile((String)outHtml, (File)out);
    }

    Model.Page newPageModel(String root, Map meta, Map blocks, String path) {
        assert (path.startsWith("/"));
        ArrayList<NavigationXml.Link> navigationSelected = new ArrayList<NavigationXml.Link>();
        for (NavigationXml.Link prototype : this.navigation) {
            String ref = prototype.ref;
            if (ref.startsWith("/")) {
                ref = root + ref;
            }
            NavigationXml.Link link = new NavigationXml.Link();
            link.ref = ref;
            link.name = prototype.name;
            link.selected = path.equals(prototype.ref);
            navigationSelected.add(link);
        }
        return new Model.Page(navigationSelected, path, root, meta, blocks);
    }

    public void run() throws Exception {
        this.init();
        this.processNavigation();
        this.processNews();
        this.generatePages();
    }

    private void init() throws Exception {
        this.templates = new StringTemplateGroup((Reader)new FileReader(this.path.expect("meta/template.stg")), DefaultTemplateLexer.class);
        this.vars = new HashMap<String, String>();
    }

    private void processNavigation() throws Exception {
        File navFile = this.path.expect("meta/navigation.xml");
        SiteBuildRunner.log("Processing", "<-", "navigation.xml");
        this.navigation = NavigationXml.deserialize((File)navFile).items;
    }

    private void processNews() throws Exception {
        File newsFile = this.path.get("meta/news.xml");
        if (newsFile != null) {
            int i;
            SiteBuildRunner.log("Processing", "<-", "news.xml");
            NewsXml.News news = NewsXml.deserialize(newsFile);
            List<NewsXml.Item> newsModel = news.items;
            ArrayList<NewsXml.Item> feedModel = new ArrayList<NewsXml.Item>(5);
            for (i = 0; i < newsModel.size(); ++i) {
                newsModel.get((int)i).odd = i % 2 == 0;
            }
            if (newsModel.size() > 5) {
                for (i = 0; i < 5 && i < newsModel.size(); ++i) {
                    feedModel.add(newsModel.get(i));
                }
            }
            StringTemplate feedTemplate = this.templates.getInstanceOf("newsfeed");
            feedTemplate.setAttribute("news", feedModel);
            this.vars.put("NEWS_SUMMARY", feedTemplate + "");
            StringTemplate pageTemplate = this.templates.getInstanceOf("news");
            pageTemplate.setAttribute("news", newsModel);
            HashMap<String, String> meta = new HashMap<String, String>();
            meta.put("title", "News");
            meta.put("keywords", "");
            HashMap<String, String> blocks = new HashMap<String, String>();
            blocks.put("body", pageTemplate + "");
            Model.Page model = this.newPageModel(".", meta, blocks, "/news.html");
            this.generateFile(model);
        }
    }

    private void generatePages() throws Exception {
        for (File topDir : this.path.sources) {
            final File rootDir = new File(topDir, "root");
            new FileUtil.Traversal(){

                String file2html(File f) throws IOException {
                    String suffix = FileUtil.fileSuffix((File)f);
                    if ("inc".equals(suffix)) {
                        String contents = IOUtil.fileToString((File)f);
                        return contents;
                    }
                    MarkupLanguage language = SiteBuildRunner.suffix2language(suffix);
                    if (language != null) {
                        String contents = IOUtil.fileToString((File)f);
                        return SiteBuildRunner.parseToHtmlFragment(language, contents);
                    }
                    return null;
                }

                Model.Page buildModelPageDir(File dir, String path) throws IOException {
                    File metaFile = new File(dir, "meta.json");
                    Map meta = JSONUtil.readMap((String)IOUtil.fileToString((File)metaFile));
                    HashMap<String, String> blocks = new HashMap<String, String>();
                    for (File f : dir.listFiles()) {
                        String name = FileUtil.removeSuffix((String)f.getName());
                        String html = this.file2html(f);
                        if (html == null) continue;
                        blocks.put(name, html);
                    }
                    String path2root = FileUtil.relativePath2Parent((File)dir.getParentFile(), (File)rootDir);
                    return SiteBuildRunner.this.newPageModel(path2root, meta, blocks, path);
                }

                Model.Page buildModelFile(File f) throws IOException {
                    String path = "/" + FileUtil.relativePath2Child((File)rootDir, (File)f);
                    path = FileUtil.replaceSuffix((String)path, (String)"html");
                    String html = this.file2html(f);
                    if (html == null) {
                        return null;
                    }
                    String name = FileUtil.removeSuffix((String)f.getName());
                    HashMap<String, String> meta = new HashMap<String, String>();
                    meta.put("title", StringUtil.capitiliseWord((String)name));
                    meta.put("keywords", "");
                    HashMap<String, String> blocks = new HashMap<String, String>();
                    blocks.put("body", html);
                    String path2root = FileUtil.relativePath2Parent((File)f.getParentFile(), (File)rootDir);
                    return SiteBuildRunner.this.newPageModel(path2root, meta, blocks, path);
                }

                protected void onFile(File f) throws Exception {
                    String fname = f.getName();
                    if (fname.equals("news.xml")) {
                        return;
                    }
                    if (fname.endsWith(".stg")) {
                        return;
                    }
                    if (fname.startsWith(".")) {
                        return;
                    }
                    Model.Page model = this.buildModelFile(f);
                    if (model != null) {
                        SiteBuildRunner.this.generateFile(model);
                    } else {
                        String path = "/" + FileUtil.relativePath2Child((File)rootDir, (File)f);
                        File outFile = new File(SiteBuildRunner.this.outDir + path);
                        SiteBuildRunner.log("Copying file", "->", path);
                        FileUtil.copy((File)f, (File)outFile);
                    }
                }

                protected boolean onDirectory(File d) throws Exception {
                    String dname = d.getName();
                    if (dname.endsWith(".page")) {
                        String path = "/" + FileUtil.relativePath2Child((File)rootDir, (File)d);
                        path = FileUtil.replaceSuffix((String)path, (String)"html");
                        SiteBuildRunner.this.generateFile(this.buildModelPageDir(d, path));
                        return false;
                    }
                    return super.onDirectory(d);
                }
            }.traverse(rootDir);
        }
    }

    static MarkupLanguage suffix2language(String suffix) {
        if ("confluence".equals(suffix)) {
            return new ConfluenceLanguage();
        }
        if ("mediawiki".equals(suffix)) {
            return new MediaWikiLanguage();
        }
        if ("textile".equals(suffix)) {
            return new TextileLanguage();
        }
        if ("tracwiki".equals(suffix)) {
            return new TracWikiLanguage();
        }
        if ("twiki".equals(suffix)) {
            return new TWikiLanguage();
        }
        return null;
    }

    public static String parseToHtmlFragment(MarkupLanguage language, String source) {
        MarkupParser parser = new MarkupParser(language);
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setEmitAsDocument(false);
        parser.setBuilder((DocumentBuilder)builder);
        parser.parse(source, false);
        parser.setBuilder(null);
        return out.toString();
    }

    private static void log(String step, String arrow, String path) {
        System.err.println(StringUtil.rpad((int)20, (String)step) + " " + arrow + " " + path);
    }

    static class SourcePath {
        final File[] sources;

        SourcePath(File ... sources) {
            this.sources = sources;
        }

        File get(String path) {
            for (File s : this.sources) {
                File f = new File(s, path);
                if (!f.exists()) continue;
                return f;
            }
            return null;
        }

        File expect(String path) throws BuildPluginException {
            File r = this.get(path);
            if (r == null) {
                throw new BuildPluginException("Expected file: " + path);
            }
            return r;
        }
    }
}

