/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.site;

import ebuild.api.IBuilderArgument;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.build.site.SiteBuildRunner;
import ebuild.build.site.spider.DefaultController;
import ebuild.build.site.spider.DefaultSpiderListener;
import ebuild.build.site.spider.Spider;
import java.io.File;
import java.util.List;

public class SiteBuilder
extends AbstractBuilder {
    public void build(IBuilderArgument arg) throws BuildPluginException {
        try {
            List sources = arg.getInputDirs("site");
            File outputRoot = arg.getOutputDir("html");
            IPropertyMap props = arg.getPropertyMap();
            new SiteBuildRunner(outputRoot, sources.toArray(new File[sources.size()])).run();
            if (props.getBool("verify-links", false)) {
                boolean verbose = arg.getEBuild().isVerbose();
                String[] ignores = arg.getPropertyMap().getString("ignore-hosts", "").split(",");
                DefaultController controller = new DefaultController(true);
                DefaultSpiderListener listener = new DefaultSpiderListener(outputRoot.toURI().toURL(), arg.getLogger(), verbose);
                for (String i : ignores) {
                    controller.ignoreHosts.add(i);
                }
                Spider spider = new Spider(listener, controller);
                spider.addPage(new File(outputRoot, "index.html").toURI().toURL());
                spider.begin();
            }
        }
        catch (BuildPluginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildPluginException((Throwable)e);
        }
    }
}

