/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.site.spider;

import ebuild.api.log.ILogger;
import ebuild.api.log.ISwitch;
import ebuild.build.site.spider.ISpiderListener;
import java.net.URL;

public class DefaultSpiderListener
implements ISpiderListener {
    final String rootUrl;
    final ILogger error;
    final ILogger verbose;

    public DefaultSpiderListener(URL rootUrl, ILogger error, final boolean verbose) {
        this(rootUrl, error, error.newSubLogger(new ISwitch(){

            public boolean isOn() {
                return verbose;
            }
        }));
    }

    public DefaultSpiderListener(URL rootUrl, ILogger error, ILogger verbose) {
        this.rootUrl = rootUrl + "";
        this.error = error;
        this.verbose = verbose;
    }

    public void verboseMessage(String msg) {
        this.verbose.log("    " + msg);
    }

    public void foundGoodLink(String href, String anchor, URL url) {
    }

    public void foundEmail(String email) {
    }

    public void foundMalformedUrl(String href) {
        this.error.log("[WARNING] Malformed URL: " + href);
    }

    public void foundBadLink(String href, String anchor, URL url) {
        this.error.log("[WARNING] Bad link: " + href);
    }

    public void pageStart(URL url) {
        String urlString = url + "";
        if (urlString.startsWith(this.rootUrl)) {
            urlString = "[site]/" + urlString.substring(this.rootUrl.length());
        }
        this.error.setProvisionalHeading("--- " + urlString + " ---");
    }

    public void pageError(String msg) {
        this.error.log("[WARNING] Problem in page: " + msg);
    }

    public void pageEnd() {
        this.error.setProvisionalHeading(null);
    }
}

