/*
 * Decompiled with CFR 0.152.
 */
package ebuild.build.site.spider;

import ebuild.build.site.spider.ISpiderController;
import ebuild.build.site.spider.ISpiderListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class Spider {
    protected final Set<URL> waiting = new LinkedHashSet<URL>(3);
    protected final Map<URL, URLStatus> pages = new HashMap<URL, URLStatus>(3);
    protected final ISpiderListener listener;
    protected final ISpiderController controller;
    protected boolean cancel = false;

    public Spider(ISpiderListener report, ISpiderController controller) {
        this.listener = report;
        this.controller = controller;
    }

    public void clear() {
        this.pages.clear();
    }

    public void cancel() {
        this.cancel = true;
    }

    public URLStatus addPage(URL url) {
        return this.addPage(url, Action.follow);
    }

    public URLStatus addPage(URL url, Action action) {
        URLStatus r = this.pages.get(url);
        if (r == null) {
            r = new URLStatus(url);
            this.pages.put(url, r);
        }
        if (action != Action.ignore && !r.checked()) {
            try {
                URLConnection conn = url.openConnection();
                if (conn instanceof HttpURLConnection) {
                    HttpURLConnection hconn = (HttpURLConnection)conn;
                    int code = hconn.getResponseCode();
                    r.exists = code < 400;
                } else {
                    conn.getInputStream();
                    r.exists = true;
                }
            }
            catch (IOException e) {
                r.exists = false;
            }
        }
        if (action == Action.follow && r.exists() && !r.processed() && !this.waiting.contains(url)) {
            this.verbose("Adding: " + url);
            this.waiting.add(url);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processURL(URL url) {
        this.waiting.remove(url);
        URLStatus status = this.pages.get(url);
        status.processed = true;
        try {
            this.listener.pageStart(url);
            URLConnection connection = url.openConnection();
            String contentType = connection.getContentType();
            if (contentType != null && !contentType.toLowerCase().startsWith("text/")) {
                this.verbose("Skipping: Content Type = " + connection.getContentType());
            } else {
                InputStream is = connection.getInputStream();
                InputStreamReader r = new InputStreamReader(is);
                HTMLEditorKit.Parser parse = new HTMLEditorKit(){

                    public HTMLEditorKit.Parser getParser() {
                        return super.getParser();
                    }
                }.getParser();
                parse.parse(r, new Parser(url), true);
            }
        }
        catch (IOException e) {
            this.listener.pageError(e.getMessage());
        }
        finally {
            this.listener.pageEnd();
        }
    }

    public void begin() {
        this.cancel = false;
        while (!this.waiting.isEmpty() && !this.cancel) {
            Object[] list = this.waiting.toArray();
            for (int i = 0; i < list.length && !this.cancel; ++i) {
                this.processURL((URL)list[i]);
            }
        }
    }

    public void verbose(String entry) {
        this.listener.verboseMessage(entry);
    }

    protected class Parser
    extends HTMLEditorKit.ParserCallback {
        protected URL base;

        public Parser(URL base) {
            this.base = base;
        }

        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            String href = (String)a.getAttribute(HTML.Attribute.HREF);
            if (href == null && t == HTML.Tag.FRAME) {
                href = (String)a.getAttribute(HTML.Attribute.SRC);
            }
            if (href == null) {
                return;
            }
            if (href.toLowerCase().startsWith("mailto:")) {
                Spider.this.listener.foundEmail(href);
            } else {
                int i = href.indexOf(35);
                String anchor = null;
                if (i != -1) {
                    anchor = href.substring(i + 1);
                    href = href.substring(0, i);
                }
                this.handleLink(this.base, href, anchor);
            }
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            this.handleSimpleTag(t, a, pos);
        }

        protected void handleLink(URL base, String href, String anchor) {
            try {
                URL url = new URL(base, href);
                Action action = Spider.this.controller.onUrl(base, href, url);
                URLStatus status = Spider.this.addPage(url, action);
                if (action != Action.ignore) {
                    if (!status.exists()) {
                        Spider.this.listener.foundBadLink(href, anchor, url);
                    } else {
                        Spider.this.listener.foundGoodLink(href, anchor, url);
                    }
                }
            }
            catch (MalformedURLException e) {
                Spider.this.listener.foundMalformedUrl(href);
            }
        }
    }

    static class URLStatus {
        public final URL url;
        public Boolean exists;
        public boolean processed = false;

        URLStatus(URL url) {
            this.url = url;
        }

        public boolean checked() {
            return this.exists != null;
        }

        public boolean exists() {
            return this.exists;
        }

        public boolean processed() {
            return this.processed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        follow,
        check,
        ignore;

    }
}

