package ebuild.lib.remap;

import java.util.HashMap;
import java.util.Map;

import org.objectweb.asm.commons.Remapper;

public class BiDiRemapper extends Remapper {
	final Map<String,String> map;
	final Map<String,String> unmap;
	
	
	public BiDiRemapper(Map<String,String> map){
		this.map = map;
		this.unmap = new HashMap(map.size());
		for(String k: map.keySet()){
			String v = map.get(k);
			if(unmap.containsKey(v))
				throw new Error("Not bijective: "+k+"->"+v);
			unmap.put(v, k);
		}
	}
	
	public String map(String t) {
		String r = map.get(t);
		if(r==null) return t;
		return r;
	}

	public String unmap(String t) {
		String r = unmap.get(t);
		if(r==null) return t;
		return r;
	}

}
