package ebuild.lib.remap;

import java.io.IOException;
import java.net.URL;

import sun.misc.Resource;
import sun.misc.URLClassPath;
import ebuild.lib.remap.RemappingUtil.RemappingError;


public class RemappingClassLoader extends ClassLoader {
	
	// TODO replace this
	final protected URLClassPath ucp;
	final protected BiDiRemapper remapper;
	
    public RemappingClassLoader(ClassLoader parent, BiDiRemapper remapper, URL[] urls) {
        super(parent);
        this.remapper = remapper;
        ucp = new URLClassPath(urls);
    }
    
    @Override
    public URL findResource(String name) {
    	return ucp.findResource(name, true);
    }
    
    @Override public Class<?> findClass(String name) throws ClassNotFoundException {
    	byte[] bytecode = findClassData(name); // I will leave this part up to you
    	byte[] remappedBytecode = remapBytecode(name, bytecode);
        return defineClass(name, remappedBytecode, 0, remappedBytecode.length);
    }

    
    private byte[] remapBytecode(String name, byte[] bytecode) {
    	try{
    		return RemappingUtil.remapClass(remapper, bytecode);
    	} catch (RemappingError e) {
	        throw new Error("Could not rewrite to class " + name);
	    }
    }
    
    
    protected byte[] findClassData(String nameWithDots) throws ClassNotFoundException{
    	String name0 = nameWithDots.replace('.', '/');
    	String name1 = remapper.unmap(name0);
    	if(name1==null) throw new ClassNotFoundException(nameWithDots);
    	
    	String path = name1.concat(".class");
    	Resource res = ucp.getResource(path, false);
		if (res == null) throw new ClassNotFoundException(nameWithDots);
		try {
			return res.getBytes();
		} catch (IOException e) {
			throw new Error(e);
		}
    }
    
}
