package ebuild.api;

import java.io.File;
import java.util.Collection;

import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;

public interface IModuleProject {
	public IElementKey getKey();
    public String getName();
    public boolean isWorkspace();
    
    @Deprecated public Collection<File> getCheckedInArtifacts(Scope s);
    public Collection<File> getCheckedInArtifacts(Scope s, String type);
    public String getJavaVersion();
    
    public File getSrcDirectory(Scope scope, String type);
    
    public Collection<? extends IModuleProject> getWorkspaceDependencies(Scope scope);
    public Collection<IModuleRelease> getReleasedDependencies(Scope scope);
    
}

