/*
 * Decompiled with CFR 0.152.
 */
package ebuild.lib.remap;

import ebuild.lib.remap.BiDiRemapper;
import ebuild.lib.remap.RemappingUtil;
import java.io.IOException;
import java.net.URL;
import sun.misc.Resource;
import sun.misc.URLClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemappingClassLoader
extends ClassLoader {
    protected final URLClassPath ucp;
    protected final BiDiRemapper remapper;

    public RemappingClassLoader(ClassLoader parent, BiDiRemapper remapper, URL[] urls) {
        super(parent);
        this.remapper = remapper;
        this.ucp = new URLClassPath(urls);
    }

    @Override
    public URL findResource(String name) {
        return this.ucp.findResource(name, true);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytecode = this.findClassData(name);
        byte[] remappedBytecode = this.remapBytecode(name, bytecode);
        return this.defineClass(name, remappedBytecode, 0, remappedBytecode.length);
    }

    private byte[] remapBytecode(String name, byte[] bytecode) {
        try {
            return RemappingUtil.remapClass(this.remapper, bytecode);
        }
        catch (RemappingUtil.RemappingError e) {
            throw new Error("Could not rewrite to class " + name, e);
        }
    }

    protected byte[] findClassData(String nameWithDots) throws ClassNotFoundException {
        String name0 = nameWithDots.replace('.', '/');
        String name1 = this.remapper.unmap(name0);
        if (name1 == null) {
            throw new ClassNotFoundException(nameWithDots);
        }
        String path = name1.concat(".class");
        Resource res = this.ucp.getResource(path, false);
        if (res == null) {
            throw new ClassNotFoundException(nameWithDots);
        }
        try {
            return res.getBytes();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

