/*
 * Decompiled with CFR 0.152.
 */
package ebuild.launch;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class LaunchUtil {
    public static final String PROP_CORE_PATH = "ebuild.core.path";

    public static ClassLoader getClassLoader() {
        String path = System.getProperty(PROP_CORE_PATH);
        if (path == null) {
            throw new Error("System property 'ebuild.core.path' not set!");
        }
        try {
            String[] ps = path.split("[\n:;]");
            URL[] urls = new URL[ps.length];
            for (int i = 0; i < ps.length; ++i) {
                urls[i] = new File(ps[i]).toURI().toURL();
            }
            return new URLClassLoader(urls);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static void launch(String runnerClass, String[] args) throws Throwable {
        ClassLoader cl = LaunchUtil.getClassLoader();
        Class<?> runner = cl.loadClass(runnerClass);
        Method m = runner.getMethod("run", ClassLoader.class, String[].class);
        try {
            m.invoke(null, cl.getParent(), args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

