/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.core.BuildPlan;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class BuildResolutionReport {
    public static BuildResolutionReport newReport(boolean verbose) {
        if (verbose) {
            return new Verbose();
        }
        return new Terse();
    }

    static String resolutionMessage(EKey k1, EKey k2) {
        if (k1.version.equals(k2.version)) {
            return k1 + "";
        }
        return k1 + " -> " + k2.version;
    }

    public void setMainPlan(BuildPlan mainPlan) {
    }

    public void addPlan(BuildPlan plan) {
    }

    public void startPlan(BuildPlan buildPlan, Scope scope) {
    }

    public void endPlan() {
    }

    public void startResolveMain() {
    }

    public void endResolveMain() {
    }

    public void startResolveBuilders() {
    }

    public void endResolveBuilders() {
    }

    public void startSection(String name) {
    }

    public void endSection() {
    }

    public abstract void resolve(EKey var1, EKey var2);

    public abstract void configure(EKey var1, ConfSet var2);

    static class Terse
    extends BuildResolutionReport {
        ILogger logger;
        Set done = new HashSet();

        Terse() {
        }

        public void setMainPlan(BuildPlan mainPlan) {
            this.logger = mainPlan.ebuild.logger;
            this.logger.log("\n--- Resolve and Configure ---");
        }

        private void log(String msg) {
            if (!this.done.contains(msg)) {
                this.logger.log(msg);
                this.done.add(msg);
            }
        }

        public void resolve(EKey k1, EKey k2) {
            this.log("  resolve: " + Terse.resolutionMessage(k1, k2));
        }

        public void configure(EKey key, ConfSet conf) {
            if (!conf.isEmpty()) {
                this.log("configure: " + key + " <--- " + conf);
            }
        }
    }

    static class Verbose
    extends BuildResolutionReport {
        Map<BuildPlan, ILogger> loggers = new HashMap<BuildPlan, ILogger>();
        private Stack<BuildPlan> stack = new Stack();
        private ILogger currentLogger;
        private BuildPlan currentPlan;

        Verbose() {
        }

        private void setPlan(BuildPlan plan) {
            this.currentPlan = plan;
            if (plan == null) {
                this.currentLogger = null;
            } else {
                this.currentLogger = this.loggers.get(this.currentPlan);
                if (this.currentLogger == null) {
                    throw new Error("Uknown plan: " + plan);
                }
            }
        }

        public void addPlan(BuildPlan plan) {
            ILogger subLogger = this.currentLogger.newSubLogger("" + plan.key);
            this.loggers.put(plan, subLogger);
        }

        public void setMainPlan(BuildPlan plan) {
            this.loggers.put(plan, plan.ebuild.logger);
        }

        public void startSection(String name) {
            this.currentLogger.setProvisionalHeading("\n--- " + name + " ---");
        }

        public void endSection() {
            this.currentLogger.setProvisionalHeading(null);
        }

        public void startPlan(BuildPlan plan, Scope scope) {
            if (this.currentPlan != null) {
                this.stack.push(this.currentPlan);
            }
            this.setPlan(plan);
            this.startSection("\n--- Subject ---");
            this.currentLogger.log(plan.getKey() + " " + scope);
        }

        public void startResolveMain() {
            this.startSection("Resolve");
        }

        public void endResolveMain() {
            this.endSection();
        }

        public void startResolveBuilders() {
            this.startSection("Resolve Builders");
        }

        public void endResolveBuilders() {
            this.endSection();
        }

        public void endPlan() {
            this.setPlan(this.stack.size() > 0 ? this.stack.pop() : null);
        }

        public void resolve(EKey k1, EKey k2) {
            this.currentLogger.log(Verbose.resolutionMessage(k1, k2));
        }

        public void configure(EKey key, ConfSet conf) {
            this.currentLogger.log(key + " <- " + conf);
        }
    }
}

