/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.BuildProject;
import ebuild.core.CDependencies;
import ebuild.core.EclipseProject;
import ebuild.core.Element;
import ebuild.core.Release;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.CEKey;
import ebuild.core.util.EBuildException;
import ebuild.util.FileUtil;
import ebuild.util.ObjectUtil;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CElement<P extends Element> {
    public final CEKey key;
    public final P element;
    public final ConfSet configuration;
    public final ConfSet configurationSelected;
    public final Release<P> release;
    private CDependencies dependencies;
    public BuildProject<P> build;
    public EclipseProject<P> eclipse;
    private Long lastModificationOfInput = null;

    public BuildProject<P> createBuildProject() {
        this.build = this.newBuildProject();
        return this.build;
    }

    public EclipseProject<P> createEclipseProject() {
        this.eclipse = this.newEclipseProject();
        return this.eclipse;
    }

    public Release<P> registerRelease() throws EBuildException {
        return this.release;
    }

    public CElement(P element, ConfSet configuration, ConfSet configurationSelected) {
        this.key = new CEKey(((Element)element).key, configuration);
        this.element = element;
        this.configuration = configuration;
        this.configurationSelected = configurationSelected;
        this.release = this.newRelease();
    }

    public abstract EclipseProject newEclipseProject();

    public abstract BuildProject newBuildProject();

    public abstract Release newRelease();

    public P getPart() {
        return this.element;
    }

    public CDependencies getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(CDependencies dependencies) {
        this.dependencies = dependencies;
    }

    public ConfSet getConfiguration() {
        return this.configuration;
    }

    public ConfSet getConfigurationSelected() {
        return this.configurationSelected;
    }

    public long lastModificationOfInput() {
        if (this.lastModificationOfInput == null) {
            long r = this.dependencies.lastModified();
            if (((Element)this.element).isSource()) {
                r = Math.max(r, ((Element)this.element).lastModificationOfSource());
            }
            this.lastModificationOfInput = r;
        }
        return this.lastModificationOfInput;
    }

    public long lastModification() {
        long r = this.lastModificationOfInput();
        r = Math.max(r, FileUtil.deepLastModified(this.getReleaseDirectory()));
        return r;
    }

    public int hashCode() {
        return ((Element)this.element).key.hashCode() + ObjectUtil.hashOf(this.configuration);
    }

    public boolean equals(Object obj) {
        CElement b = (CElement)obj;
        return ((Element)this.element).key.equals(((Element)b.element).key) && ObjectUtil.areEqual(this.configuration, b.configuration);
    }

    public String toString() {
        return ((Element)this.element).toString() + " - " + this.configuration.toString();
    }

    public File getReleaseDirectory() {
        return new File(((Element)this.getPart()).getReleaseDirectory(), this.configuration.asDirectoryName());
    }
}

