/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IAssemblerArgument;
import ebuild.api.IEBuild;
import ebuild.api.IInputMap;
import ebuild.api.IModuleRelease;
import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.core.BuildProject;
import ebuild.core.CElement;
import ebuild.core.Component;
import ebuild.core.ComponentCDependencies;
import ebuild.core.ComponentCPart;
import ebuild.core.ComponentProjectHelper;
import ebuild.core.ComponentRelease;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.Module;
import ebuild.core.ModuleCDependencies;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Input;
import ebuild.core.impl.InputMap;
import ebuild.core.impl.Version;
import ebuild.core.util.EBuildException;
import ebuild.core.util.ExcludePattern;
import ebuild.util.CollectionUtil;
import ebuild.util.FileUtil;
import ebuild.xml.ComponentXml;
import ebuild.xml.Xml;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBuildProject
extends BuildProject<Component> {
    private final EBuild ebuild;
    private final Component component;
    private final ComponentCPart cElement;

    public ComponentBuildProject(ComponentCPart cElement) {
        super((CElement)cElement);
        this.cElement = cElement;
        this.component = (Component)cElement.element;
        this.ebuild = this.component.ebuild;
    }

    @Override
    public boolean isDirty() {
        return super.isDirty();
    }

    @Override
    public long releaseLastModified() {
        return FileUtil.deepLastModified(this.cElement.releaseFile());
    }

    @Override
    public void buildRun() throws Exception {
        ArtifactGenerator releaseGenerator = this.construct();
        Collection<File> artifacts = releaseGenerator.assemble(this.ebuild);
        if (artifacts.size() != 1) {
            throw EBuildException.newProblem("Expected single artifact from release, got " + artifacts.size());
        }
        File a = artifacts.iterator().next();
        FileUtil.copy(a, this.cElement.release.getFile());
    }

    public ArtifactGenerator construct() throws EBuildException, BuildPluginException {
        ComponentProjectHelper phelper = this.component.getProjectHelper();
        final EBuildContext context = phelper.context;
        ComponentProjectHelper componentProjectHelper = phelper;
        componentProjectHelper.getClass();
        return (ArtifactGenerator)new ComponentProjectHelper.AssemblyVisitor<ArtifactGenerator>(componentProjectHelper, this.getConfiguration()){
            {
                ComponentProjectHelper componentProjectHelper = x0;
                componentProjectHelper.getClass();
                super(componentProjectHelper, x1);
            }

            @Override
            ArtifactGenerator visitGroup(String path, ComponentXml.AssemblyGroup group, List<ArtifactGenerator> members) {
                return new AssemblyGroup(path, members);
            }

            @Override
            ArtifactGenerator visitAssembler(String path, ComponentXml.Assembler assemblerXml, Map<String, ArtifactGenerator> inputs) throws EBuildException {
                EKey assemblerKey = context.newModuleKey(assemblerXml);
                Module assemblerModule = (Module)((ComponentBuildProject)ComponentBuildProject.this).cElement.getDependencies().builders.get(assemblerKey);
                EKey resolvedKey = assemblerModule.key;
                AbstractAssembler assembler = ComponentBuildProject.this.ebuild.expectAssembler(resolvedKey);
                IPropertyMap properties = EBuildUtil.configureProperties(assembler.newPropertyMap(), ComponentBuildProject.this.getConfiguration(), assemblerXml.propsList);
                return new AssemblerInstance(path, assembler, inputs, properties);
            }

            @Override
            ArtifactGenerator visitComponent(String path, Xml.SelectAndMap component) {
                ComponentCDependencies deps = ComponentBuildProject.this.cElement.getDependencies();
                ComponentCDependencies.ComponentDep dep = deps.components.get(path);
                return new ComponentSelect(path, (ComponentRelease)dep.cElement.release);
            }

            @Override
            ArtifactGenerator visitModuleSelection(String path, ComponentXml.ModuleSelection ms) throws EBuildException {
                final ArrayList<Exclude> excludes = new ArrayList<Exclude>(ms.excludes.size());
                for (Xml.SelectWithSource exclude : ms.excludes) {
                    excludes.add(new Exclude(exclude));
                }
                CollectionUtil.Filter<ModuleCDependencies.AbstractDep> inclusionFilter = new CollectionUtil.Filter<ModuleCDependencies.AbstractDep>(){

                    @Override
                    public boolean accept(ModuleCDependencies.AbstractDep dep) {
                        if (dep.scope != Scope.MAIN) {
                            return false;
                        }
                        for (Exclude ex : excludes) {
                            if (!ex.match(dep.key)) continue;
                            return false;
                        }
                        return true;
                    }
                };
                HashSet<IModuleRelease> modules = new HashSet<IModuleRelease>();
                ComponentCDependencies deps = ComponentBuildProject.this.cElement.getDependencies();
                ComponentCDependencies.ModuleSelectionDep dep = deps.moduleSelections.get(path);
                dep.buildModuleCollection(inclusionFilter, modules);
                String[] artifactTypes = ms.artifactType.split(",");
                return new ModuleSelectionInstance(path, modules, artifactTypes);
            }
        }.go();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComponentSelect
    extends ArtifactGenerator {
        final ComponentRelease release;

        ComponentSelect(String path, ComponentRelease release) {
            super(path);
            this.release = release;
        }

        @Override
        Collection<File> assemble_(EBuild ebuild) throws Exception {
            return CollectionUtil.singletonList(this.release.getFile());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ModuleSelectionInstance
    extends ArtifactGenerator {
        final Collection<IModuleRelease> modules;
        final String[] artifactTypes;

        public ModuleSelectionInstance(String path, Collection<IModuleRelease> modules, String[] artifactTypes) {
            super(path);
            this.modules = modules;
            this.artifactTypes = artifactTypes;
        }

        @Override
        Collection<File> assemble_(EBuild ebuild) throws Exception {
            ArrayList<File> r = new ArrayList<File>(this.modules.size());
            for (IModuleRelease m : this.modules) {
                for (String type : this.artifactTypes) {
                    r.addAll(m.getArtifacts(Scope.MAIN, type));
                }
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AssemblerInstance
    extends ArtifactGenerator {
        final AbstractAssembler assembler;
        final Map<String, ArtifactGenerator> inputGenerators;
        final IPropertyMap properties;

        public AssemblerInstance(String path, AbstractAssembler assembler, Map<String, ArtifactGenerator> inputGenerators, IPropertyMap properties) throws EBuildException {
            super(path);
            this.assembler = assembler;
            this.inputGenerators = inputGenerators;
            this.properties = properties;
        }

        @Override
        public Collection<File> assemble_(final EBuild ebuild) throws Exception {
            final InputMap inputs = new InputMap();
            for (String key : this.inputGenerators.keySet()) {
                ArtifactGenerator apc = this.inputGenerators.get(key);
                Collection<File> a = apc.assemble(ebuild);
                inputs.put(key, new Input(key, a));
            }
            IAssemblerArgument arg = new IAssemblerArgument(){

                public IEBuild getEBuild() {
                    return ebuild;
                }

                public ILogger getLogger() {
                    return ebuild.logger.newSubLogger(AssemblerInstance.this.assembler.getClass().getSimpleName());
                }

                public IPropertyMap getPropertyMap() {
                    return AssemblerInstance.this.properties;
                }

                public IInputMap getInputMap() {
                    return inputs;
                }

                public File getOutputDirectory() {
                    return AssemblerInstance.this.useOutputDir();
                }

                public Date getLastCommitDate() {
                    return ComponentBuildProject.this.component.getLastCommitDate();
                }

                public String getVersionString() {
                    return "" + ((ComponentBuildProject)ComponentBuildProject.this).component.key.version;
                }

                public IElementKey getComponentKey() {
                    return ((ComponentBuildProject)ComponentBuildProject.this).component.key;
                }

                public String getReleaseFileName() {
                    return ComponentBuildProject.this.cElement.releaseFileName();
                }
            };
            arg.getLogger().prime();
            return this.assembler.assemble(arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AssemblyGroup
    extends ArtifactGenerator {
        final List<ArtifactGenerator> generators;

        AssemblyGroup(String path, List<ArtifactGenerator> generators) {
            super(path);
            this.generators = generators;
        }

        @Override
        public Collection<File> assemble_(EBuild ebuild) throws Exception {
            ArrayList<File> r = new ArrayList<File>(this.generators.size());
            for (ArtifactGenerator g : this.generators) {
                r.addAll(g.assemble(ebuild));
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class ArtifactGenerator {
        private final File outputDir;
        private Collection<File> artifacts = null;

        public ArtifactGenerator(String path) {
            this.outputDir = new File(ComponentBuildProject.this.getIntermediateDirectory(), path);
        }

        final Collection<File> assemble(EBuild ebuild) throws Exception {
            if (this.artifacts == null) {
                this.artifacts = this.assemble_(ebuild);
            }
            return this.artifacts;
        }

        abstract Collection<File> assemble_(EBuild var1) throws Exception;

        public File useOutputDir() {
            this.outputDir.mkdirs();
            return this.outputDir;
        }
    }

    private static class Exclude {
        final ExcludePattern org;
        final ExcludePattern name;
        final ExcludePattern version;
        final ExcludePattern branch;
        final ExcludePattern revision;

        Exclude(Xml.SelectWithSource pattern) {
            this.org = ExcludePattern.compile(pattern.org);
            this.name = ExcludePattern.compile(pattern.name);
            this.version = ExcludePattern.compile(pattern.getTag());
            this.branch = ExcludePattern.compile(pattern.branch);
            this.revision = ExcludePattern.compile(pattern.revision);
        }

        boolean match(EKey key) {
            if (!this.org.matches(key.org)) {
                return false;
            }
            if (!this.name.matches(key.name)) {
                return false;
            }
            Version v = key.version;
            if (v.isTag()) {
                if (!this.version.matches(v.getTag())) {
                    return false;
                }
            } else {
                if (!this.branch.matches(v.getBranch())) {
                    return false;
                }
                if (!this.revision.matches(v.getRevision())) {
                    return false;
                }
            }
            return true;
        }
    }
}

