/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.api.plugin.AbstractAssembler;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.repo.AbstractRepositoryProvider;
import ebuild.core.CElement;
import ebuild.core.EBuild;
import ebuild.core.Element;
import ebuild.core.ElementNature;
import ebuild.core.ModuleCDependencies;
import ebuild.core.ModuleCPart;
import ebuild.core.ModuleProjectHelper;
import ebuild.core.ModuleRelease;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.BuilderPrototype;
import ebuild.core.impl.EBuildMode;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.impl.EKey;
import ebuild.core.util.EBuildException;
import ebuild.util.Logger;
import ebuild.xml.ModuleXml;
import ebuild.xml.Xml;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module
extends Element<ModuleXml.EbuildModule> {
    public final EBuild ebuild;
    private ModuleXml.EbuildBuildPlugin pluginXml;
    File pluginFile;
    private AbstractRepositoryProvider repositoryProvider = null;

    public Module(EBuildMode mode, File directory, EBuild ebuild, EKey key, ElementNature nature) throws EBuildException {
        super(mode, directory, ebuild, key, nature);
        this.ebuild = ebuild;
        File pluginFile = new File(this.getMetaDirectory(), "build-plugin.xml");
        if (pluginFile.exists()) {
            this.pluginFile = pluginFile;
        }
    }

    public AbstractRepositoryProvider getRepositoryProvider() {
        return this.repositoryProvider;
    }

    @Override
    public CElement newCPart(ConfSet conf, ConfSet confSelected) {
        return new ModuleCPart(this, conf, confSelected);
    }

    @Override
    public ModuleProjectHelper newProjectHelper() {
        return new ModuleProjectHelper(this);
    }

    @Override
    public ModuleProjectHelper getProjectHelper() {
        return (ModuleProjectHelper)super.getProjectHelper();
    }

    @Override
    public ElementType getType() {
        return ElementType.module;
    }

    public boolean isPlugin() {
        return this.pluginFile != null;
    }

    public ModuleXml.EbuildBuildPlugin getPluginXml() throws EBuildException {
        if (this.pluginXml == null) {
            this.pluginXml = (ModuleXml.EbuildBuildPlugin)EBuildUtil.parseXml(this.ebuild, this.pluginFile);
        }
        return this.pluginXml;
    }

    public Iterable<Xml.SelectAndMap> getDependenciesXml() {
        return ((ModuleXml.EbuildModule)this.getDeclaration()).dependencies.list;
    }

    public String getJavaVersion() {
        for (Xml.SelectAndMap d : this.getDependenciesXml()) {
            if (!"system".equals(d.source) || !"jre".equals(d.name)) continue;
            return d.getTag();
        }
        return "1.6";
    }

    public void registerRelease(CElement cElement) throws EBuildException {
        if (this.isPlugin()) {
            ModuleXml.EbuildBuildPlugin pluginXml = this.getPluginXml();
            if (pluginXml.isBuilder()) {
                this.createBuilder(cElement);
            } else if (pluginXml.isAssembler()) {
                this.createAssembler(cElement);
            } else if (pluginXml.isRepositoryProvider()) {
                this.createRepositoryProvider(cElement);
            }
        }
    }

    private Collection<String> getClasspath_(CElement cElement, Scope scope) {
        LinkedHashSet<String> elements = new LinkedHashSet<String>();
        ((ModuleRelease)cElement.release).buildClassPath(scope, elements);
        ModuleCDependencies mcdeps = (ModuleCDependencies)cElement.getDependencies();
        mcdeps.buildClassPath(scope, elements);
        return elements;
    }

    private void logPluginPath(Collection<String> elements) {
        Logger l = this.ebuild.logger;
        l.log("plugin runtime path for '" + this.key + "': ");
        for (String s : elements) {
            l.log("    " + this.ebuild.formatAsDisplayPath(new File(s)));
        }
    }

    public Collection<String> getClassPath(CElement cElement, Scope scope) {
        Collection<String> elements = this.getClasspath_(cElement, scope);
        if (this.ebuild.isVerbose()) {
            this.logPluginPath(elements);
        }
        return elements;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object buildPluginInstance(CElement cElement, String class_) throws EBuildException {
        try {
            Collection<String> files = this.getClassPath(cElement, Scope.MAIN);
            ArrayList<URL> urls = new ArrayList<URL>(files.size());
            for (String s : files) {
                urls.add(new File(s).toURI().toURL());
            }
            URL[] urlArray = urls.toArray(new URL[files.size()]);
            URLClassLoader moduleCl = new URLClassLoader(urlArray, this.ebuild.apiClassLoader);
            ClassLoader coreCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(moduleCl);
                Class<?> pluginClass = moduleCl.loadClass(class_);
                Object obj = pluginClass.newInstance();
                return obj;
            }
            catch (ClassNotFoundException e) {
                String msg = "Unable to instantiate build plugin '" + class_ + "': class does not exist!";
                throw EBuildException.newProblem(msg);
            }
            finally {
                Thread.currentThread().setContextClassLoader(coreCl);
            }
        }
        catch (EBuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    void createBuilder(CElement cElement) throws EBuildException {
        Object o = this.buildPluginInstance(cElement, this.getPluginXml().declareBuilder.class_);
        if (!(o instanceof AbstractBuilder)) {
            throw EBuildException.newProblem("Build Plugin class not an instanceof " + AbstractBuilder.class.getName());
        }
        ModuleXml.DeclareBuilder decl = this.pluginXml.declareBuilder;
        this.ebuild.registerBuilder(this.key, new BuilderPrototype(this.key, (AbstractBuilder)o, decl.exports));
    }

    void createAssembler(CElement cElement) throws EBuildException {
        Object o = this.buildPluginInstance(cElement, this.getPluginXml().declareAssembler.class_);
        if (!(o instanceof AbstractAssembler)) {
            throw EBuildException.newProblem("Build Plugin class not an instanceof " + AbstractAssembler.class.getName());
        }
        this.ebuild.registerBuilder(this.key, (AbstractAssembler)o);
    }

    void createRepositoryProvider(CElement cElement) throws EBuildException {
        Object o = this.buildPluginInstance(cElement, this.getPluginXml().declareRepositoryProvider.class_);
        if (!(o instanceof AbstractRepositoryProvider)) {
            throw EBuildException.newProblem("Build Plugin class not an instanceof " + AbstractRepositoryProvider.class.getName());
        }
        this.repositoryProvider = (AbstractRepositoryProvider)o;
    }

    public boolean isApi() {
        return this.key.universe == null && "ebuild".equals(this.key.org) && this.key.name.startsWith("api");
    }
}

