/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IBuilderArgument;
import ebuild.api.common.Scope;
import ebuild.api.log.ILogger;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IPropertyMap;
import ebuild.api.repo.IRepository;
import ebuild.core.BuilderInstance;
import ebuild.core.CElement;
import ebuild.core.EBuild;
import ebuild.core.Module;
import ebuild.core.ModuleCDependencies;
import ebuild.core.Project;
import ebuild.core.ProjectHelper;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.EBuildUtil;
import ebuild.core.util.EBuildException;
import ebuild.util.FileUtil;
import ebuild.util.ZipUtil;
import ebuild.xml.ModuleXml;
import ebuild.xml.Xml;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleProjectHelper
extends ProjectHelper {
    private final Module module;
    private ModuleXml.EbuildModuleBuild buildXml;
    private Boolean singleFolderLayout = null;

    ModuleProjectHelper(Module module) {
        super(module);
        this.module = module;
    }

    private boolean isSingleFolderLayout() {
        if (this.singleFolderLayout == null) {
            this.singleFolderLayout = new File(this.module.getProjectDirectory(), "src_main").exists();
        }
        return this.singleFolderLayout;
    }

    public File getSrcDirectory(Scope scope, String type) {
        return new File(this.module.getProjectDirectory(), this.getSrcFolder(false, scope, type));
    }

    public String getSrcFolder(boolean gen, Scope scope, String type) {
        return this.getSrcFolder(gen ? "gen" : "src", scope, type);
    }

    public String getSrcFolder(String kind, Scope scope, String type) {
        if (this.isSingleFolderLayout()) {
            return kind + "_" + scope;
        }
        return kind + "/" + scope + "/" + type;
    }

    private Module module() {
        return this.module;
    }

    @Override
    public ModuleXml.EbuildModuleBuild getBuildXml() throws EBuildException {
        if (this.buildXml == null) {
            File f = new File(this.module().getMetaDirectory(), "module-build.xml");
            this.buildXml = (ModuleXml.EbuildModuleBuild)EBuildUtil.parseXml(this.module.ebuild, f);
        }
        return this.buildXml;
    }

    public List<? extends Xml.Builder> getBuildDependencies(ConfSet configuration) throws EBuildException {
        return this.getBuildXml().builders;
    }

    public IPropertyMap configureProperties(Project<Module> project, BuilderInstance builderInstance) throws BuildPluginException, EBuildException {
        return EBuildUtil.configureProperties(builderInstance.getBuilder().newPropertyMap(), project.getConfiguration(), builderInstance.propList);
    }

    public Collection<File> getCheckedInArtifacts(CElement cElement, Scope s, String type) {
        ModuleCDependencies mcdeps = (ModuleCDependencies)cElement.getDependencies();
        Collection<ModuleCDependencies.CheckedInDep> deps = mcdeps.getCheckedInsForScope(s).values();
        ArrayList<File> r = new ArrayList<File>(deps.size());
        for (ModuleCDependencies.CheckedInDep d : deps) {
            if (type != null && !type.equals(d.type)) continue;
            r.add(d.getFile());
        }
        return r;
    }

    public String getJavaVersion() {
        return this.module().getJavaVersion();
    }

    public void build(AbstractBuilderArgument arg, BuilderInstance b) throws IOException, BuildPluginException {
        ILogger logger = arg.getLogger();
        IPropertyMap props = arg.getPropertyMap();
        logger.setProvisionalHeading("Properties");
        for (String k : props.listKeys()) {
            Object v = props.get(k);
            logger.log("    " + k + ": " + v);
        }
        for (ModuleXml.Export e : b.getProtoType().exports) {
            if (!e.beforeBuild) continue;
            this.exportArtifacts(arg, e);
        }
        b.build(arg);
        for (ModuleXml.Export e : b.getProtoType().exports) {
            if (e.beforeBuild) continue;
            this.exportArtifacts(arg, e);
        }
    }

    private void exportArtifacts(AbstractBuilderArgument arg, ModuleXml.Export export) throws IOException {
        ILogger logger = arg.getLogger();
        String type = export.type;
        List<File> sources = arg.getInputDirs(type);
        if (!export.archive) {
            File target = arg.getExportDirectory(type);
            target.mkdirs();
            for (File s : sources) {
                FileUtil.copy(s, target, EBuildUtil.getFileFilter(this.module.getRepository()));
            }
        } else {
            String suffix = export.archiveSuffix;
            if (suffix == null) {
                suffix = "zip";
            }
            type = type + "." + suffix;
            Collection<File> checkedIn = this.getCheckedInArtifacts(arg.getCPart(), arg.scope, type);
            if (checkedIn.size() > 0 || export.named) {
                File target = arg.getExportDirectory(type + ".group");
                target.mkdirs();
                String archiveName = this.module.key.fullnameAndVersion() + "." + suffix;
                File archive = new File(target, archiveName);
                this.createArchive(logger, archive, sources);
                for (File c : this.getCheckedInArtifacts(arg.getCPart(), arg.scope, type)) {
                    logger.log("Copying checked-in: " + this.module.ebuild.formatAsDisplayPath(c));
                    FileUtil.copyToDir(c, target);
                }
            } else {
                File archive = arg.getExportDirectory(type);
                archive.getParentFile().mkdirs();
                this.createArchive(logger, archive, sources);
            }
        }
    }

    private void createArchive(ILogger logger, File archive, List<File> sources) throws IOException {
        if (sources.size() > 0) {
            logger.log("Creating archive: " + this.module.ebuild.formatAsDisplayPath(archive));
            IRepository repo = this.module.getRepository();
            FileFilter filter = EBuildUtil.getFileFilter(repo);
            if (archive.getName().endsWith(".jar")) {
                ZipUtil.jarDirectories(archive, sources, filter);
            } else {
                ZipUtil.zipDirectories(archive, sources, filter);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractBuilderArgument
    implements IBuilderArgument {
        final Project<Module> project;
        final AbstractBuilder builder;
        final IPropertyMap props;
        final Scope scope;

        AbstractBuilderArgument(Project<Module> project, AbstractBuilder builder, Scope scope, IPropertyMap props) {
            this.project = project;
            this.builder = builder;
            this.props = props;
            this.scope = scope;
        }

        public abstract File getExportDirectory(String var1);

        public abstract CElement getCPart();

        protected abstract File getGenDirectory(String var1);

        public EBuild getEBuild() {
            return this.project.getPart().ebuild;
        }

        public ILogger getLogger() {
            return this.getEBuild().logger.newSubLogger(this.builder.getClass().getSimpleName());
        }

        public IPropertyMap getPropertyMap() {
            return this.props;
        }

        public Scope getScope() {
            return this.scope;
        }

        public List<File> getInputDirs(String artifactType) {
            File genDir;
            ArrayList<File> r = new ArrayList<File>(2);
            ModuleProjectHelper phelper = this.project.getPart().getProjectHelper();
            File srcDir = this.project.getProjectFile(phelper.getSrcFolder("src", this.scope, artifactType));
            if (srcDir.exists()) {
                r.add(srcDir);
            }
            if ((genDir = this.getGenDirectory(artifactType)) != null && genDir.exists()) {
                r.add(genDir);
            }
            return r;
        }
    }
}

