/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.CElement;
import ebuild.core.Element;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.BuildMode;
import ebuild.core.impl.Version;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Project<P extends Element> {
    protected final CElement<P> cElement;

    protected Project(CElement<P> cElement) {
        this.cElement = cElement;
    }

    public P getPart() {
        return this.cElement.element;
    }

    public ConfSet getConfiguration() {
        return this.cElement.configuration;
    }

    public ConfSet getConfigurationSelected() {
        return this.cElement.configurationSelected;
    }

    public abstract BuildMode mode();

    public CElement getCPart() {
        return this.cElement;
    }

    public String getName() {
        return ((Element)this.getPart()).getName();
    }

    public Version getVersion() {
        return ((Element)this.getPart()).getVersion();
    }

    public File getProjectFile(String path) {
        return new File(((Element)this.getPart()).getProjectDirectory(), path);
    }

    public File getSourceFile(String path) {
        return this.getProjectFile(path);
    }

    public boolean isBuilt() {
        return this.cElement.getReleaseDirectory().exists();
    }

    public String toString() {
        return this.mode().code + " " + ((Element)this.getPart()).key + " " + this.getConfiguration();
    }
}

