/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.conf;

import ebuild.core.conf.ConfSet;

public interface ConfExpr {
    public static final ConfExpr TRUE = new ConfExpr(){

        public boolean evaluate(ConfSet input) {
            return true;
        }

        public String toString() {
            return "";
        }
    };

    public boolean evaluate(ConfSet var1);

    public static class Not
    implements ConfExpr {
        private final ConfExpr e;

        Not(ConfExpr e) {
            this.e = e;
        }

        public boolean evaluate(ConfSet input) {
            return !this.e.evaluate(input);
        }

        public String toString() {
            return "!" + this.e;
        }
    }

    public static class Or
    implements ConfExpr {
        private final ConfExpr a;
        private final ConfExpr b;

        Or(ConfExpr a, ConfExpr b) {
            this.a = a;
            this.b = b;
        }

        public boolean evaluate(ConfSet input) {
            return this.a.evaluate(input) || this.b.evaluate(input);
        }

        public String toString() {
            return "(" + this.a + "|" + this.b + ")";
        }
    }

    public static class And
    implements ConfExpr {
        private final ConfExpr a;
        private final ConfExpr b;

        And(ConfExpr a, ConfExpr b) {
            this.a = a;
            this.b = b;
        }

        public boolean evaluate(ConfSet input) {
            return this.a.evaluate(input) && this.b.evaluate(input);
        }

        public String toString() {
            return "(" + this.a + "," + this.b + ")";
        }
    }

    public static class Conf
    implements ConfExpr {
        final String conf;

        Conf(String conf) {
            this.conf = conf;
        }

        public boolean evaluate(ConfSet input) {
            return input.includes(this.conf);
        }

        public String toString() {
            return this.conf;
        }
    }
}

