/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.conf;

import ebuild.core.conf.ConfExpr;
import ebuild.core.conf.ConfSet;
import ebuild.util.CollectionUtil;
import ebuild.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfMapping {
    public static final ConfMapping EMPTY = new ConfMapping(CollectionUtil.EMPTY_SET);
    public final Collection<Item> items;

    ConfMapping(Collection<Item> items) {
        this.items = items;
    }

    public ConfSet select(ConfSet input) {
        ConfSet.Builder r = new ConfSet.Builder();
        for (Item e : this.items) {
            e.select(input, r);
        }
        return r.build();
    }

    public String toString() {
        ArrayList<String> r = new ArrayList<String>(this.items.size());
        for (Item e : this.items) {
            r.add(e.toString());
        }
        Collections.sort(r);
        return StringUtil.join(";", r);
    }

    public static class Item {
        public final ConfExpr expr;
        public final ConfSet to;

        public Item(ConfExpr expr, ConfSet to) {
            this.expr = expr;
            this.to = to;
        }

        public void select(ConfSet input, ConfSet.Builder r) {
            if (this.expr.evaluate(input)) {
                r.addAll(this.to.asCollection());
            }
        }

        public String toString() {
            return this.expr.toString() + "->" + this.to.toString();
        }
    }
}

