/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.conf;

import ebuild.core.conf.ConfExprException;
import ebuild.core.conf.Token;
import ebuild.core.util.SmartReader;
import java.io.IOException;
import java.io.Reader;

public class Lexer {
    protected Token op;
    protected String string = null;
    protected String sourceName;
    protected int parserLine;
    protected SmartReader in;
    private int pushBackDepth = 0;
    private Token[] pushBackInts = new Token[3];
    private Object[] pushBackObjects = new Object[3];
    private int[] pushBackLines = new int[3];

    public Lexer(Reader r) {
        this.in = new SmartReader(r);
    }

    protected ConfExprException le(String msg) {
        return new ConfExprException("[lexing error] " + msg + " at " + this.sourceName + ":" + this.in.line() + ":" + this.in.col());
    }

    protected Token throwle(String msg) throws ConfExprException {
        throw this.le(msg);
    }

    protected Token getIdentifier(int c) throws IOException {
        String str;
        this.in.startString();
        while (Character.isJavaIdentifierPart((char)(c = this.in.read()))) {
        }
        this.in.unread();
        this.string = str = this.in.getString();
        return Token.NAME;
    }

    protected Token _getToken() throws IOException, ConfExprException {
        int c;
        while ((c = this.in.read()) == 32 || c == 9 || c == 12 || c == 11 || c == 10 || c == 13) {
        }
        if (c == -1) {
            return Token.END;
        }
        if (c == 92 || Character.isJavaIdentifierStart((char)c)) {
            return this.getIdentifier(c);
        }
        switch (c) {
            case 40: {
                return Token.LP;
            }
            case 41: {
                return Token.RP;
            }
            case 44: {
                return Token.COMMA;
            }
            case 33: {
                return Token.BANG;
            }
            case 124: {
                return Token.OR;
            }
            case 59: {
                return Token.SEMI;
            }
            case 45: {
                return this.in.match('>') ? Token.MAP : this.throwle("-" + this.in.peek() + " is not a valid token");
            }
        }
        throw this.le("illegal character: '" + (char)c + "'");
    }

    public final void pushBackToken(Token op, Object obj) {
        if (this.pushBackDepth >= this.pushBackInts.length - 1) {
            Token[] newInts = (Token[])new Object[this.pushBackInts.length * 2];
            System.arraycopy(this.pushBackInts, 0, newInts, 0, this.pushBackInts.length);
            this.pushBackInts = newInts;
            Object[] newObjects = new Object[this.pushBackObjects.length * 2];
            System.arraycopy(this.pushBackObjects, 0, newObjects, 0, this.pushBackObjects.length);
            this.pushBackObjects = newObjects;
            int[] newLines = new int[this.pushBackLines.length * 2];
            System.arraycopy(this.pushBackLines, 0, newInts, 0, this.pushBackLines.length);
            this.pushBackLines = newLines;
        }
        this.pushBackInts[this.pushBackDepth] = op;
        this.pushBackObjects[this.pushBackDepth] = obj;
        this.pushBackLines[this.pushBackDepth] = this.parserLine;
        ++this.pushBackDepth;
    }

    public final void pushBack() {
        this.pushBackToken(this.op, this.string);
    }

    public final Token peek() throws IOException, ConfExprException {
        Token ret = this.nextToken();
        this.pushBack();
        return ret;
    }

    public final Token nextToken() throws IOException, ConfExprException {
        this.string = null;
        if (this.pushBackDepth == 0) {
            Token r = this.op = this._getToken();
            this.parserLine = this.in.line();
            return r;
        }
        --this.pushBackDepth;
        this.op = this.pushBackInts[this.pushBackDepth];
        if (this.pushBackObjects[this.pushBackDepth] != null) {
            this.string = this.pushBackObjects[this.pushBackDepth] instanceof String ? (String)this.pushBackObjects[this.pushBackDepth] : null;
        }
        this.parserLine = this.pushBackLines[this.pushBackDepth];
        return this.op;
    }
}

