/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.util;

import ebuild.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionNumber
implements Comparable<VersionNumber> {
    private final int[] value;

    public VersionNumber(int ... value) {
        this.value = value;
    }

    public static VersionNumber fromString(String s) {
        String[] ss = s.split("\\.");
        int[] is = new int[ss.length];
        if (is.length == 0) {
            return null;
        }
        for (int i = 0; i < ss.length; ++i) {
            Integer n = StringUtil.tryParseInt(ss[i]);
            if (n == null) {
                return null;
            }
            is[i] = n;
        }
        return new VersionNumber(is);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VersionNumber) {
            VersionNumber b = (VersionNumber)obj;
            if (b.value.length != this.value.length) {
                return false;
            }
            for (int i = 0; i < this.value.length; ++i) {
                if (b.value[i] == this.value[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.value.length; ++i) {
            h = 31 * h + this.value[i];
        }
        return h;
    }

    @Override
    public int compareTo(VersionNumber b) {
        int la = this.value.length;
        int lb = b.value.length;
        int l = Math.min(la, lb);
        for (int i = 0; i < l; ++i) {
            int va = this.value[i];
            int vb = b.value[i];
            if (va > vb) {
                return 1;
            }
            if (vb <= va) continue;
            return -1;
        }
        return la - lb;
    }

    public String toString() {
        return StringUtil.join(".", this.value);
    }
}

