/*
 * Decompiled with CFR 0.152.
 */
package ebuild.util;

import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import ebuild.util.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipUtil {
    private static final FileFilter ACCEPT_ALL = new FileFilter(){

        public boolean accept(File pathname) {
            return true;
        }
    };

    private static void zip(File x, String path, ZipOutputStream z, FileFilter filter) throws IOException {
        if (!filter.accept(x)) {
            return;
        }
        if (!x.exists()) {
            throw new IOException("File not found: " + x);
        }
        if (!x.isDirectory()) {
            z.putNextEntry(new JarEntry(path + "/" + x.getName()));
            FileInputStream y = new FileInputStream(x);
            IOUtil.pipeKeepOpen(y, z);
            z.closeEntry();
            y.close();
        } else {
            if (!"".equals(path)) {
                path = path + "/";
            }
            ZipUtil.zipDir(x, path + x.getName(), z, filter);
        }
    }

    private static void zipDir(File x, String path, ZipOutputStream z, FileFilter filter) throws IOException {
        for (File x2 : x.listFiles()) {
            ZipUtil.zip(x2, path, z, filter);
        }
    }

    public static void zipDirectories(File archive, List<File> dirs) throws IOException {
        ZipUtil.zipDirectories(archive, dirs, ACCEPT_ALL);
    }

    public static void zipDirectories(File archive, List<File> dirs, FileFilter filter) throws IOException {
        ZipOutputStream z = new ZipOutputStream(new FileOutputStream(archive));
        for (File dir : dirs) {
            ZipUtil.zipDir(dir, "", z, filter);
        }
        z.close();
    }

    public static void zipDirectoryIncludeName(File archive, File dir) throws IOException {
        ZipUtil.zipDirectoryIncludeName(archive, dir, ACCEPT_ALL);
    }

    public static void zipDirectoryIncludeName(File archive, File dir, FileFilter filter) throws IOException {
        ZipUtil.zipDirectory(archive, dir, dir.getName(), filter);
    }

    public static void zipDirectory(File archive, File dir, String prefix) throws IOException {
        ZipUtil.zipDirectory(archive, dir, prefix, ACCEPT_ALL);
    }

    public static void zipDirectory(File archive, File dir, String prefix, FileFilter filter) throws IOException {
        ZipOutputStream z = new ZipOutputStream(new FileOutputStream(archive));
        ZipUtil.zipDir(dir, prefix, z, filter);
        z.close();
    }

    public static void jarDirectories(File archive, List<File> dirs) throws IOException {
        ZipUtil.jarDirectories(archive, dirs, ACCEPT_ALL);
    }

    public static void jarDirectories(File archive, List<File> dirs, FileFilter filter) throws IOException {
        JarOutputStream z = new JarOutputStream(new FileOutputStream(archive));
        for (File dir : dirs) {
            ZipUtil.zipDir(dir, "", z, filter);
        }
        z.close();
    }

    public static void unzipArchiveAndRename(File archive, File outputDir) throws IOException {
        File tempDir = FileUtil.createTempDirectory("unzipTo");
        ZipUtil.unzipArchive(archive, tempDir);
        String[] dirs = tempDir.list();
        if (dirs.length != 1) {
            throw new IOException("Expected single top dir in archive got " + dirs.length + ": " + StringUtil.join(",", dirs));
        }
        File top = new File(tempDir, dirs[0]);
        FileUtil.moveDir(top, outputDir);
        FileUtil.deleteDirOrFail(tempDir);
    }

    public static void unzipArchive(File archive, File outputDir) throws IOException {
        ZipFile zipfile = new ZipFile(archive);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            ZipUtil.unzipEntry(zipfile, entry, outputDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            FileUtil.mkdirOrFail(new File(outputDir, entry.getName()));
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        FileUtil.mkdirOrFail(outputFile.getParentFile());
        InputStream inputStream = zipfile.getInputStream(entry);
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        try {
            IOUtil.pipe(inputStream, outputStream);
        }
        finally {
            ((OutputStream)outputStream).close();
            inputStream.close();
        }
    }
}

