/*
 * Decompiled with CFR 0.152.
 */
package ebuild.xml;

import ebuild.util.StringUtil;
import ebuild.xml.Xml;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

public class ComponentXml {

    public static class Input
    extends AssemblyGroup {
        @Attribute(required=false)
        public String name;

        public String appendToPath(String path) {
            return path + "-" + (this.name != null ? this.name : "input");
        }
    }

    public static class Assembler
    extends Xml.SelectWithSource {
        @ElementList(empty=false, required=false, inline=true)
        public List<Input> inputList;
        @ElementList(empty=false, required=false, inline=true)
        public List<Xml.Property> propsList;
    }

    public static class If
    extends Xml {
        @Attribute
        public String confs;
        @Element(name="Then")
        public AssemblyGroup then;
        @Element(required=false, name="Else")
        public AssemblyGroup else_;
    }

    public static class Ref
    extends Xml {
        @Attribute
        public String name;
    }

    public static class Include
    extends Xml.SelectAndMap {
        @Attribute(required=false)
        public boolean dependencies = true;
    }

    public static class OurModule {
        @Attribute(required=false)
        public String confs;
        @Attribute(required=false)
        public String mapping;
        @Attribute(required=false)
        public boolean dependencies = true;
    }

    public static class Component
    extends Xml.SelectAndMap {
    }

    public static class ModuleSelection
    extends Xml {
        @Attribute
        public String artifactType;
        @Attribute(required=false)
        public String groupMapping;
        @Element(required=false)
        public OurModule ourModule;
        @ElementList(entry="Include", required=false, empty=false, inline=true)
        public List<Include> includes;
        @ElementList(entry="Exclude", required=false, empty=false, inline=true)
        public List<Xml.SelectWithSource> excludes;
    }

    public static class AssemblyResult
    extends AssemblyGroup {
        @Attribute
        public String name;
    }

    public static class AssemblyGroup
    extends Xml {
        @Attribute(required=false)
        public String ref;
        @ElementList(empty=false, required=false, inline=true)
        public List<Ref> refs = new ArrayList<Ref>(0);
        @ElementList(empty=false, required=false, inline=true)
        public List<Assembler> assemblers;
        @ElementList(empty=false, required=false, inline=true, entry="Component")
        public List<Component> components;
        @ElementList(empty=false, required=false, inline=true)
        public List<ModuleSelection> moduleSelections;
        @ElementList(empty=false, required=false, inline=true, entry="If")
        public List<If> ifs;

        public String getDefaultElementName() {
            return StringUtil.camelCaseToDashed(this.getClass().getSimpleName());
        }

        public int count() {
            return (this.ref == null ? 0 : 1) + this.refs.size() + this.assemblers.size() + this.components.size() + this.moduleSelections.size() + this.ifs.size();
        }
    }

    public static class Assembly
    extends Xml {
        @Attribute
        public String release;
        @ElementList(inline=true, required=false, empty=false)
        public List<AssemblyResult> assemblyResults;
    }

    @Root
    public static class EbuildComponentAssembly
    extends Xml.EBuildRoot {
        @Element
        public Assembly assembly;
    }

    public static class Release
    extends Xml {
        @Attribute(required=false)
        public String name;
        @Attribute(required=false)
        public String suffix;
        @Attribute(required=false)
        public String pattern;
    }

    @Root
    public static class EbuildComponent
    extends Xml.EBuildElement {
        @Element
        public Release release;
    }
}

