/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.core.Action;
import ebuild.core.ActionQueue;
import ebuild.core.ActionStatus;
import ebuild.core.BuildProject;
import ebuild.core.BuildResolutionReport;
import ebuild.core.BuilderInstance;
import ebuild.core.CDependencies;
import ebuild.core.CElement;
import ebuild.core.EBuild;
import ebuild.core.EBuildContext;
import ebuild.core.EBuildRunner;
import ebuild.core.EclipseProject;
import ebuild.core.Element;
import ebuild.core.Module;
import ebuild.core.ModuleBuildPlan;
import ebuild.core.ProjectHelper;
import ebuild.core.conf.ConfSet;
import ebuild.core.impl.CEKey;
import ebuild.core.impl.EKey;
import ebuild.core.impl.Task;
import ebuild.core.util.EBuildException;
import ebuild.core.util.WorkMarker;
import ebuild.util.tuple.Pair;
import ebuild.xml.Xml;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildPlan {
    final EBuild ebuild;
    final EBuildRunner runner;
    final BuildResolutionReport report;
    final Object key;
    protected final Set<Object> builderPlans = new LinkedHashSet<Object>();
    static Set<BuildPlan> norecur = new HashSet<BuildPlan>();
    private Set<Pair<EKey, EKey>> resolved = new HashSet<Pair<EKey, EKey>>();

    public BuildPlan(EBuildRunner runner, Object key) {
        this.ebuild = runner.ebuild;
        this.runner = runner;
        this.report = runner.report;
        this.key = key;
        runner.buildPlans.put(this.getKey(), this);
    }

    public Object getKey() {
        return this.key;
    }

    protected abstract void resolveBuilders(Scope var1) throws EBuildException;

    protected abstract void resolveAndConfigure_(Scope var1, Scope var2) throws EBuildException;

    protected abstract void buildActionList_(ActionQueue var1, Task var2) throws Exception;

    protected abstract Collection<CElement> gatherReleases() throws EBuildException;

    public void resolveAndConfigure(Scope scope, Scope builderScope) throws EBuildException {
        if (norecur.contains(this)) {
            throw new Error("Cyclical dependency: " + this);
        }
        norecur.add(this);
        try {
            this.report.startPlan(this, scope);
            this.resolveAndConfigure_(scope, builderScope);
            this.report.startResolveBuilders();
            this.resolveBuilders(scope);
            this.report.endResolveBuilders();
            for (Object subKey : this.builderPlans) {
                ModuleBuildPlan subPlan = (ModuleBuildPlan)this.runner.buildPlans.get(subKey);
                subPlan.resolveAndConfigure(builderScope, builderScope);
            }
            this.report.endPlan();
        }
        finally {
            norecur.remove(this);
        }
    }

    public void buildActionList(ActionQueue queue, Task task) throws Exception {
        for (Object subKey : this.builderPlans) {
            BuildPlan subPlan = this.runner.buildPlans.get(subKey);
            subPlan.buildActionList(queue, task);
            if (task != Task.eclipse_setup || !(this instanceof ModuleBuildPlan)) continue;
            subPlan.buildActionList(queue, Task.build_release);
        }
        this.buildActionList_(queue, task);
    }

    protected void buildActionListForPart(ActionQueue queue, Task task, CElement cElement) throws Exception {
        Object element = cElement.getPart();
        if (!((Element)element).isWorkspace()) {
            if (((Element)element).isSource()) {
                WorkMarker marker = new WorkMarker(((Element)element).getProjectDirectory());
                Action.FetchSource action = new Action.FetchSource(marker, (Element)element);
                queue.add(action);
            } else {
                String confDir = cElement.configuration.asDirectoryName();
                WorkMarker marker = new WorkMarker(new File(((Element)element).getReleaseDirectory(), confDir));
                queue.add(new Action.FetchArtifacts(marker, cElement));
            }
            if (task.isIDE()) {
                throw new Error("Tried to do IDE task on a library element: " + cElement);
            }
            if (task == Task.fetch_source) {
                return;
            }
        }
        switch (task) {
            case build_release: {
                if (!((Element)element).isSource()) break;
                BuildProject bproject = cElement.createBuildProject();
                ActionStatus status = bproject.isDirty() ? ActionStatus.dirty : (bproject.isClean() ? ActionStatus.todo : ActionStatus.done);
                queue.add(new Action.BuildRelease(status, cElement, this.runner));
                break;
            }
            case build_clean: {
                if (!((Element)element).isSource()) break;
                ActionStatus status = ((Element)element).buildIsClean() ? ActionStatus.done : ActionStatus.todo;
                queue.add(new Action.BuildClean(status, cElement));
                break;
            }
            case eclipse_setup: {
                if (!((Element)element).isWorkspace()) break;
                EclipseProject eproject = cElement.createEclipseProject();
                ActionStatus status = eproject.isProjectDirty() ? ActionStatus.dirty : ActionStatus.todo;
                queue.add(new Action.EclipseSetup(status, cElement));
                break;
            }
            case eclipse_unsetup: {
                cElement.createEclipseProject();
                ActionStatus status = ActionStatus.todo;
                queue.add(new Action.EclipseUnsetup(status, cElement));
            }
        }
    }

    protected Element resolveElement(EBuildContext from, String source, EKey dkey) throws EBuildException {
        Element r = from.resolveElement(source, dkey);
        Pair<EKey, EKey> res = new Pair<EKey, EKey>(dkey, r.key);
        if (!this.resolved.contains(res)) {
            this.resolved.add(res);
            this.report.resolve((EKey)res.a, (EKey)res.b);
        }
        return r;
    }

    private Module resolveModule(EBuildContext from, Xml.SelectWithSource d) throws EBuildException {
        EKey dkey = from.newElementKey(ElementType.module, d);
        return (Module)this.resolveElement(from, d.source, dkey);
    }

    protected EBuildContext resolveContext(Element element) throws EBuildException {
        return this.resolveContext(element.context, (Xml.EBuildRoot)element.getDeclaration());
    }

    protected EBuildContext resolveContext(ProjectHelper phelper) throws EBuildException {
        EBuildContext r = this.resolveContext(phelper.context, phelper.getBuildXml());
        return r;
    }

    private EBuildContext resolveContext(EBuildContext context, Xml.EBuildRoot xml) throws EBuildException {
        context.addParents(this.ebuild.context);
        for (Xml.Repository repoXml : xml.repositories) {
            context.addRepository(repoXml);
        }
        int l = xml.usings.size();
        EBuildContext[] add = new EBuildContext[l];
        int i = 0;
        while (i < l) {
            Xml.Using d = xml.usings.get(i);
            Module delement = this.resolveModule(context, d);
            EBuildContext dcontext = d.isBuild() ? this.resolveContext(delement.expectProjectHelper()) : this.resolveContext(delement);
            add[i] = dcontext;
            ++i;
        }
        context.addParents(add);
        return context;
    }

    protected void resolveBuildersForPart(CElement cElement) throws EBuildException {
        Object element = cElement.element;
        if (!((Element)element).isSource()) {
            return;
        }
        ProjectHelper phelper = ((Element)element).getProjectHelper();
        EBuildContext bcontext = phelper.context;
        EBuildContext.start(bcontext);
        try {
            this.resolveContext(phelper);
            CDependencies deps = cElement.getDependencies();
            Iterable<Xml.SelectWithSource> ds = phelper.getBuildDependencies(cElement.getConfiguration());
            for (Xml.SelectWithSource d : ds) {
                if (d.isRefId()) continue;
                EKey bekey = bcontext.newModuleKey(d);
                Module belement = (Module)this.resolveElement(bcontext, d.source, bekey);
                CElement cModule = belement.getCPart(ConfSet.EMPTY);
                CEKey bcekey = new CEKey(belement.key, ConfSet.EMPTY);
                ModuleBuildPlan subPlan = (ModuleBuildPlan)this.runner.buildPlans.get(cModule.key);
                if (subPlan == null) {
                    if (!(belement instanceof Module)) {
                        throw EBuildException.newProblem("Builder element is not a module, got: " + belement.getType());
                    }
                    subPlan = new ModuleBuildPlan(this.runner, cModule);
                    assert (subPlan.getKey().equals(bcekey));
                    assert (this.runner.buildPlans.get(bcekey) != null);
                    this.report.addPlan(subPlan);
                }
                this.builderPlans.add(subPlan.getKey());
                deps.addBuilder(bekey, subPlan.expectModule());
                String id = d.getId();
                if (id == null || bcontext.getBuilder(id) != null) continue;
                bcontext.addBuilder(id, new BuilderInstance(subPlan.expectModule(), ((Xml.Builder)d).propertiesList));
            }
        }
        finally {
            EBuildContext.end();
        }
    }

    public String toString() {
        return "" + this.getKey();
    }
}

