/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.core.BuildProject;
import ebuild.core.CElement;
import ebuild.core.Component;
import ebuild.core.ComponentBuildProject;
import ebuild.core.ComponentCDependencies;
import ebuild.core.ComponentRelease;
import ebuild.core.EclipseProject;
import ebuild.core.Release;
import ebuild.core.conf.ConfSet;
import ebuild.core.util.NameTemplate;
import ebuild.xml.ComponentXml;
import ebuild.xml.Xml;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentCPart
extends CElement<Component> {
    public ComponentCPart(Component component, ConfSet conf, ConfSet confSelected) {
        super(component, conf, confSelected);
    }

    @Override
    public BuildProject newBuildProject() {
        return new ComponentBuildProject(this);
    }

    @Override
    public EclipseProject newEclipseProject() {
        return new EclipseProject<Component>((CElement)this){};
    }

    @Override
    public Release newRelease() {
        return new ComponentRelease(this.releaseFile());
    }

    @Override
    public ComponentCDependencies getDependencies() {
        return (ComponentCDependencies)super.getDependencies();
    }

    public String releaseFileName() {
        String r = ((Component)this.element).getNameTemplateOfOutput().apply(new NameTemplate.Model(){

            public String getValue(String varname) {
                if ("confs".equals(varname)) {
                    return ComponentCPart.this.getConfigurationSelected().asFileTrailingPart(((Component)ComponentCPart.this.element).getConfsNotUsedInName());
                }
                if ("version".equals(varname)) {
                    return "" + ((Component)ComponentCPart.this.element).key.version;
                }
                return null;
            }
        });
        r = String.valueOf(r) + this.getAdditionalSuffixes();
        return r;
    }

    public File releaseFile() {
        return new File(((Component)this.element).getReleaseDirectory(), this.releaseFileName());
    }

    public String getAdditionalSuffixes() {
        String r = "";
        for (Xml.Configuration c : ((ComponentXml.EbuildComponent)((Component)this.element).getDeclaration()).configurations) {
            if (!this.getConfiguration().includes(c.name) || c.suffix == null) continue;
            r = String.valueOf(r) + c.suffix;
        }
        return r;
    }
}

