/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IEBuild;
import ebuild.api.IGenConfArgument;
import ebuild.api.IModuleBuildProject;
import ebuild.api.IModuleRelease;
import ebuild.api.IModuleWorkspaceProject;
import ebuild.api.common.IElementKey;
import ebuild.api.common.Scope;
import ebuild.api.plugin.IPropertyMap;
import ebuild.core.BuilderChain;
import ebuild.core.BuilderInstance;
import ebuild.core.CElement;
import ebuild.core.EBuild;
import ebuild.core.EclipseProject;
import ebuild.core.Module;
import ebuild.core.ModuleCDependencies;
import ebuild.core.ModuleCPart;
import ebuild.core.ModuleProjectHelper;
import ebuild.util.FileUtil;
import ebuild.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleEclipseProject
extends EclipseProject<Module>
implements IModuleWorkspaceProject,
IModuleBuildProject {
    private Module module;
    private final ModuleProjectHelper helper;
    private List<String> natures = new ArrayList<String>(2);
    private List<String> buildCommands = new ArrayList<String>(2);
    private static final Scope[] CALL_ORDER = new Scope[]{Scope.MAIN, Scope.POKE, Scope.TEST};

    public ModuleEclipseProject(CElement<Module> cElement) {
        super((CElement)cElement);
        this.module = (Module)this.getPart();
        this.helper = this.module.getProjectHelper();
    }

    @Override
    public ModuleCPart getCPart() {
        return (ModuleCPart)super.getCPart();
    }

    public File getSrcDirectory(Scope scope, String type) {
        return this.helper.getSrcDirectory(scope, type);
    }

    public String getSrcPath(boolean gen, Scope scope, String type) {
        return this.helper.getSrcFolder(gen, scope, type);
    }

    public String getArtifactPath(String kind, Scope scope, String type) {
        return this.helper.getSrcFolder(kind, scope, type);
    }

    public boolean isWorkspace() {
        return ((Module)this.getPart()).isWorkspace();
    }

    public Collection<File> getCheckedInArtifacts(Scope s) {
        return this.getCheckedInArtifacts(s, null);
    }

    public Collection<File> getCheckedInArtifacts(Scope s, String type) {
        return this.helper.getCheckedInArtifacts(this.cElement, s, type);
    }

    public String getJavaVersion() {
        return this.helper.getJavaVersion();
    }

    public IElementKey getKey() {
        return this.module.key;
    }

    public Collection<IModuleRelease> getDependencies(Scope scope) {
        throw new UnsupportedOperationException();
    }

    public IModuleRelease getModuleRelease() {
        throw new UnsupportedOperationException();
    }

    public String getVersionString() {
        return "" + ((Module)this.getPart()).key.version;
    }

    public void addIgnores(String ... patterns) {
        this.module.addIgnores(patterns);
    }

    public void addNature(String nature) {
        this.natures.add(nature);
    }

    public void addBuildCommand(String builder) {
        this.buildCommands.add(builder);
    }

    public Collection<IModuleWorkspaceProject> getWorkspaceDependencies() {
        return this.getWorkspaceDependencies(Scope.TEST);
    }

    public Collection<IModuleRelease> getLibraryDependencies() {
        return this.getReleasedDependencies(Scope.TEST);
    }

    public Collection<IModuleRelease> getReleasedDependencies(Scope scope) {
        ModuleCDependencies deps = (ModuleCDependencies)this.cElement.getDependencies();
        HashSet<IModuleRelease> r = new HashSet<IModuleRelease>(deps.elements.size());
        for (ModuleCDependencies.PartDep pd : deps.elements.values()) {
            if (pd.cElement.eclipse != null || !scope.includes(pd.scope)) continue;
            r.add((IModuleRelease)pd.cElement.release);
        }
        return r;
    }

    public Collection<IModuleWorkspaceProject> getWorkspaceDependencies(Scope scope) {
        ModuleCDependencies deps = (ModuleCDependencies)this.cElement.getDependencies();
        HashSet<IModuleWorkspaceProject> r = new HashSet<IModuleWorkspaceProject>(deps.elements.size());
        for (ModuleCDependencies.PartDep pd : deps.elements.values()) {
            if (pd.cElement.eclipse == null || !scope.includes(pd.scope)) continue;
            r.add((IModuleWorkspaceProject)pd.cElement.eclipse);
        }
        return r;
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        long projectModified = this.getSourceFile(".project").lastModified();
        final EBuild ebuild = this.module.ebuild;
        ModuleProjectHelper helper = this.module.getProjectHelper();
        BuilderChain chain = this.getCPart().configureAndParameterizeBuilderChain();
        for (BuilderInstance b : chain.getBuilders()) {
            final IPropertyMap props = helper.configureProperties(this, b);
            if (b.hasEclipseNature()) {
                b.generateEclipseProjectSettings(new IGenConfArgument(){

                    public IModuleWorkspaceProject getModuleWorkspaceProject() {
                        return ModuleEclipseProject.this;
                    }

                    public IEBuild getEBuild() {
                        return ebuild;
                    }

                    public IPropertyMap getPropertyMap() {
                        return props;
                    }
                });
                continue;
            }
            Scope[] scopeArray = CALL_ORDER;
            int n = CALL_ORDER.length;
            int n2 = 0;
            while (n2 < n) {
                Scope s = scopeArray[n2];
                ModuleProjectHelper.AbstractBuilderArgument arg = new ModuleProjectHelper.AbstractBuilderArgument(this, b.getBuilder(), s, props){

                    public boolean isBuild() {
                        return false;
                    }

                    public boolean isFirstCall() {
                        return this.scope == CALL_ORDER[0];
                    }

                    public CElement getCPart() {
                        return ModuleEclipseProject.this.cElement;
                    }

                    public File getExportDirectory(String artifactType) {
                        throw new Error("!");
                    }

                    protected File getGenDirectory(String artifactType) {
                        return new File(ModuleEclipseProject.this.module.getProjectDirectory(), ModuleEclipseProject.this.getSrcPath(true, this.getScope(), artifactType));
                    }

                    public File getIntermediateDir(String uniquePath) {
                        throw new UnsupportedOperationException();
                    }

                    public IModuleBuildProject getModuleBuildProject() {
                        return ModuleEclipseProject.this;
                    }

                    public File getOutputDir(String artifactType) {
                        return this.getGenDirectory(artifactType);
                    }
                };
                b.build(arg);
                ++n2;
            }
        }
        if (projectModified == this.getSourceFile(".project").lastModified()) {
            this.generateDotProject();
        }
    }

    @Override
    public void unsetup() throws Exception {
        super.unsetup();
        FileUtil.deleteDir(this.module.getFile("gen"));
        this.module.getFile(".classpath").delete();
    }

    private void generateDotProject() throws IOException {
        StringTemplate template = ModuleEclipseProject.getTemplate("project");
        template.setAttribute("name", this.module.getName());
        template.setAttribute("natures", this.natures);
        template.setAttribute("buildCommands", this.buildCommands);
        this.writeFile(".project", template.toString());
    }

    private static StringTemplateGroup getTemplateGroup(String name) throws IOException {
        URL url = ModuleEclipseProject.class.getResource(name);
        InputStream is = url.openStream();
        return new StringTemplateGroup((Reader)new InputStreamReader(is), DefaultTemplateLexer.class);
    }

    private static StringTemplate getTemplate(String name) throws IOException {
        return ModuleEclipseProject.getTemplateGroup(String.valueOf(name) + ".stg").getInstanceOf(name);
    }

    private void writeFile(String path, String contents) throws IOException {
        IOUtil.stringToFile(contents, this.getSourceFile(path));
    }
}

