/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.impl;

import ebuild.api.common.ElementType;
import ebuild.api.common.Scope;
import ebuild.api.plugin.IPropertyMap;
import ebuild.api.repo.AbstractSourceRepository;
import ebuild.api.repo.IRepository;
import ebuild.api.repo.RepositoryPluginException;
import ebuild.core.conf.ConfExpr;
import ebuild.core.conf.ConfExprException;
import ebuild.core.conf.ConfMapping;
import ebuild.core.conf.ConfSet;
import ebuild.core.conf.Parser;
import ebuild.core.impl.Version;
import ebuild.core.util.EBuildException;
import ebuild.core.util.PathJanitor;
import ebuild.util.FileUtil;
import ebuild.xml.Xml;
import java.io.File;
import java.io.FileFilter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EBuildUtil {
    private static final FileFilter FILEFILTER_DEFAULT = new FileFilter(){

        public boolean accept(File f) {
            return !".svn".equals(f.getName());
        }
    };
    public static final String FILENAME_CMP_DECL = "component.xml";
    public static final String FILENAME_CMP_BUILD = "component-assembly.xml";
    public static final String FILENAME_MOD_DECL = "module.xml";
    public static final String FILENAME_MOD_BUILD = "module-build.xml";

    public static String getHeadRevision(AbstractSourceRepository repo) throws EBuildException {
        try {
            return repo.getHeadRevision();
        }
        catch (RepositoryPluginException e) {
            throw EBuildException.wrapPluginException("Could not fetch head revision of '" + repo.getUri() + "'", e);
        }
    }

    public static Version asVersion(Xml.Version v) {
        return EBuildUtil.asVersion(v, null);
    }

    public static Version asVersion(Xml.Version v, Version default_) {
        String tag = v.getTag();
        if (tag != null) {
            return Version.newTag(tag);
        }
        if (v.getBranch() != null || v.getRevision() != null) {
            return Version.newRevision(v.getBranch(), v.getRevision());
        }
        return default_;
    }

    public static Xml parseXml(PathJanitor ebuild, File f) throws EBuildException {
        try {
            return Xml.deserialize(f);
        }
        catch (Exception e) {
            throw EBuildException.newProblem(String.valueOf(ebuild.formatAsDisplayPath(f)) + " : " + e.getMessage());
        }
    }

    public static FileFilter getFileFilter(IRepository repo) {
        if (!(repo instanceof AbstractSourceRepository)) {
            return FILEFILTER_DEFAULT;
        }
        AbstractSourceRepository srepo = (AbstractSourceRepository)repo;
        FileFilter r = srepo.getFileFilter();
        if (r == null) {
            r = FILEFILTER_DEFAULT;
        }
        return r;
    }

    public static String elementType2xmlName(ElementType elementType) {
        switch (elementType) {
            case component: {
                return FILENAME_CMP_DECL;
            }
            case module: {
                return FILENAME_MOD_DECL;
            }
        }
        throw new Error("!");
    }

    public static String elementType2buildXmlName(ElementType elementType) {
        switch (elementType) {
            case component: {
                return FILENAME_CMP_BUILD;
            }
            case module: {
                return FILENAME_MOD_BUILD;
            }
        }
        throw new Error("!");
    }

    public static ElementType determineElementType(File directory) throws EBuildException {
        File metaDir = new File(directory, "meta");
        if (new File(metaDir, FILENAME_CMP_DECL).isFile()) {
            return ElementType.component;
        }
        if (new File(metaDir, FILENAME_MOD_DECL).isFile()) {
            return ElementType.module;
        }
        throw EBuildException.newProblem("Not an ebuild directory: " + FileUtil.canonicalFile(directory));
    }

    public static Scope getScope(String name, Scope default_) {
        Scope r = Scope.get((String)name);
        if (r == null) {
            return default_;
        }
        return r;
    }

    public static ConfMapping parseMapping(String mapping) throws EBuildException {
        return EBuildUtil.parseMapping(mapping, ConfMapping.EMPTY);
    }

    public static ConfMapping parseMapping(String mapping, ConfMapping default_) throws EBuildException {
        if (mapping == null) {
            return default_;
        }
        try {
            return Parser.parseConfMapping(mapping);
        }
        catch (ConfExprException e) {
            throw EBuildException.newProblem("Invalid mapping '" + mapping + "' - " + e.getMessage());
        }
    }

    public static ConfExpr parseConfExpr(String expr) throws EBuildException {
        try {
            return Parser.parseConfExpr(expr);
        }
        catch (ConfExprException e) {
            throw EBuildException.newProblem("Invalid expr '" + expr + "' - " + e.getMessage());
        }
    }

    public static boolean evaluateConfExpr(String expr, ConfSet confs) throws EBuildException {
        ConfExpr r = EBuildUtil.parseConfExpr(expr);
        return r.evaluate(confs);
    }

    public static ConfSet parseConfSet(String confSet) throws EBuildException {
        try {
            return Parser.parseConfSet(confSet);
        }
        catch (ConfExprException e) {
            throw EBuildException.newProblem("Invalid mapping '" + confSet + "' - " + e.getMessage());
        }
    }

    public static IPropertyMap configureProperties(IPropertyMap r, ConfSet configuration, List<Xml.Property> propList) throws EBuildException {
        for (Xml.Property p : propList) {
            if (!EBuildUtil.evaluateConfExpr(p.confs, configuration)) continue;
            r.put(p.key, p.getValue());
        }
        return r;
    }
}

