/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.util;

import java.util.regex.Pattern;

public class ExcludePattern {
    public static final ExcludePattern ALL = ExcludePattern.compile("*");
    private final boolean negative;
    private final Pattern regexp;

    private ExcludePattern(boolean negative, Pattern regexp) {
        this.regexp = regexp;
        this.negative = negative;
    }

    public boolean matches(String s) {
        boolean r = this.regexp.matcher(s).matches();
        if (this.negative) {
            r = !r;
        }
        return r;
    }

    public static ExcludePattern compile(String pattern) {
        if (pattern == null) {
            return ALL;
        }
        boolean negative = (pattern = pattern.trim()).startsWith("!");
        if (negative) {
            pattern = pattern.substring(1);
        }
        String regex = pattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
        return new ExcludePattern(negative, Pattern.compile(regex));
    }
}

