/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core.util;

import ebuild.util.IOUtil;
import java.io.File;
import java.io.IOException;

public class WorkMarker {
    private final File file;
    private final File marker;

    public WorkMarker(File f) {
        this.file = f;
        this.marker = new File(f.getParent(), String.valueOf(f.getName()) + ".inprogress");
    }

    public boolean isComplete() {
        return this.file.exists() && !this.marker.exists();
    }

    public boolean isInProgress() {
        return this.marker.exists();
    }

    public void create() {
        try {
            this.marker.getParentFile().mkdirs();
            IOUtil.stringToFile("", this.marker);
        }
        catch (IOException e) {
            throw new Error("Could not create work marker: " + this.marker + "\n " + e.getMessage());
        }
    }

    public void remove() {
        if (!this.marker.delete()) {
            throw new Error("Could not delete work marker: " + this.marker);
        }
    }
}

