/*
 * Decompiled with CFR 0.152.
 */
package ebuild.options;

import ebuild.options.OptionsUtil;
import ebuild.options.Required;
import ebuild.util.CollectionUtil;
import ebuild.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsBuilder {
    private final Class optionsClass;
    private final Object optionsObj;
    private final List<Problem> problems = new LinkedList<Problem>();
    private final Set<String> set = new HashSet<String>();

    public OptionsBuilder(Object optionsObj) {
        this.optionsClass = optionsObj.getClass();
        this.optionsObj = optionsObj;
    }

    public void addError(String message) {
        this.problems.add(new Problem(message, true));
    }

    public void addWarning(String message) {
        this.problems.add(new Problem(message, false));
    }

    public Set<String> getSetOptions() {
        return this.set;
    }

    public void merge(Map<String, String> optionsMap, boolean isSet) {
        for (String k : optionsMap.keySet()) {
            if (this.set.contains(k)) continue;
            if (isSet) {
                this.set.add(k);
            }
            String v = optionsMap.get(k);
            this.translate(StringUtil.camelCaseFromDashed(k), v);
        }
    }

    public void merge(Map<String, String> optionsMap) {
        this.merge(optionsMap, true);
    }

    public void mergeDefault(Map<String, String> optionsMap) {
        this.merge(optionsMap, false);
    }

    public void mergeArgs(String[] args) {
        this.merge(OptionsUtil.read(args));
    }

    public void mergePropertiesFile(File file) {
        try {
            this.merge(OptionsUtil.readPropertyFile(file));
        }
        catch (IOException e) {
            this.addError("Could not properties file: " + file);
        }
    }

    public Collection<Problem> doVerify() {
        Collection<String> missing = OptionsBuilder.required(this.optionsClass);
        missing.removeAll(this.set);
        for (String key : missing) {
            this.addError("Required field '" + key + "' not set");
        }
        return this.problems;
    }

    public void verify() {
        Collection<Problem> problems = this.doVerify();
        if (problems.size() > 0) {
            boolean exit = false;
            for (Problem p : problems) {
                System.err.println("" + p);
                if (!p.error) continue;
                exit = true;
            }
            if (exit) {
                System.exit(1);
            }
        }
    }

    public List<String> check() {
        ArrayList<String> r = new ArrayList<String>(this.problems.size());
        for (Problem p : this.problems) {
            r.add(p.message);
        }
        return r;
    }

    private void translate(String key, String value) {
        boolean hasValue;
        Field f;
        try {
            f = this.optionsClass.getField(key);
        }
        catch (NoSuchFieldException e) {
            this.addWarning("Invalid configuration property: " + key);
            return;
        }
        boolean bl = hasValue = !StringUtil.isEmptyString(value);
        if (!hasValue) {
            return;
        }
        try {
            Object v = this.getValue(f, value);
            f.set(this.optionsObj, v);
        }
        catch (Exception e) {
            this.addError(e.getMessage());
        }
    }

    private Object getValue(String fname, Class type, String value) {
        if (Boolean.TYPE == type) {
            return Boolean.parseBoolean(value);
        }
        if (Integer.TYPE == type) {
            return Integer.parseInt(value);
        }
        if (Integer.class == type) {
            return Integer.parseInt(value);
        }
        if (type.isEnum()) {
            Class enumClass = type;
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                if (!e.name().equals(value)) continue;
                return e;
            }
            String list = StringUtil.join(",", enumClass.getEnumConstants());
            this.addError("Expected one of '" + list + "' property '" + fname + "'");
            return null;
        }
        if (File.class == type) {
            return new File(value);
        }
        if (String.class == type) {
            return value;
        }
        throw new Error("Unsupported type: " + type.getName());
    }

    private Object getValue(Field field, String value) {
        Type gtype = field.getGenericType();
        if (gtype instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)gtype;
            if (ptype.getRawType() != List.class) {
                throw new Error("Unsupported type: " + ptype);
            }
            List<String> vals = CollectionUtil.newList(value.split(","));
            ArrayList<Object> r = new ArrayList<Object>(vals.size());
            Type p = ptype.getActualTypeArguments()[0];
            for (String s : vals) {
                Object v = this.getValue(field.getName(), (Class)p, s);
                r.add(v);
            }
            return r;
        }
        return this.getValue(field.getName(), field.getType(), value);
    }

    private static Collection<String> required(Class optionsClass) {
        Field[] fields;
        HashSet<String> r = new HashSet<String>();
        for (Field f : fields = optionsClass.getFields()) {
            if (f.getAnnotation(Required.class) == null) continue;
            r.add(StringUtil.camelCaseToDashed(f.getName()));
        }
        return r;
    }

    public static class Problem {
        public final String message;
        public final boolean error;

        public Problem(String message, boolean error) {
            this.message = message;
            this.error = error;
        }

        public String toString() {
            return (this.error ? "[ERROR]" : "[WARNING]") + this.message;
        }
    }
}

