/*
 * Decompiled with CFR 0.152.
 */
package ebuild.launch;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;

public class LaunchUtil {
    public static final String PROP_CORE_PATH = "ebuild.core.path";

    public static ClassLoader getClassLoader() {
        URL[] sysUrlsArr;
        HashSet<URL> sysUrls = new HashSet<URL>();
        URL[] uRLArray = sysUrlsArr = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs();
        int n = sysUrlsArr.length;
        int n2 = 0;
        while (n2 < n) {
            URL u = uRLArray[n2];
            sysUrls.add(u);
            ++n2;
        }
        String path = System.getProperty(PROP_CORE_PATH);
        if (path == null) {
            throw new Error("System property 'ebuild.core.path' not set!");
        }
        try {
            String[] ps = path.split("[\n:;]");
            ArrayList<URL> urls = new ArrayList<URL>(ps.length);
            int i = 0;
            while (i < ps.length) {
                URL url = new File(ps[i]).toURI().toURL();
                if (!sysUrls.contains(url)) {
                    urls.add(url);
                }
                ++i;
            }
            return new URLClassLoader(urls.toArray(new URL[urls.size()]));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static void launch(String runnerClass, String[] args) throws Throwable {
        ClassLoader cl = LaunchUtil.getClassLoader();
        Class<?> runner = cl.loadClass(runnerClass);
        Method m = runner.getMethod("run", ClassLoader.class, String[].class);
        try {
            m.invoke(null, cl.getParent(), args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

