/*
 * Decompiled with CFR 0.152.
 */
package ebuild.core;

import ebuild.api.IBuilderArgument;
import ebuild.api.IGenConfArgument;
import ebuild.api.plugin.AbstractBuilder;
import ebuild.api.plugin.BuildPluginException;
import ebuild.api.plugin.IEclipseNature;
import ebuild.core.Module;
import ebuild.core.impl.BuilderPrototype;
import ebuild.core.util.EBuildException;
import ebuild.xml.Xml;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderInstance {
    public final Module module;
    public final List<Xml.Property> propList;
    private BuilderPrototype prototype;

    public BuilderInstance(Module module, List<Xml.Property> props) {
        this.module = module;
        this.propList = props;
    }

    public void init() throws EBuildException {
        this.prototype = this.module.ebuild.expectBuilder(this.module.key);
    }

    public BuilderPrototype getProtoType() {
        if (this.prototype == null) {
            throw new Error("Not initialized!");
        }
        return this.prototype;
    }

    public AbstractBuilder getBuilder() {
        return this.getProtoType().builder;
    }

    public boolean hasEclipseNature() throws EBuildException {
        return this.getBuilder() instanceof IEclipseNature;
    }

    public void build(IBuilderArgument argument) throws BuildPluginException {
        Thread t = Thread.currentThread();
        ClassLoader old = t.getContextClassLoader();
        t.setContextClassLoader(this.getBuilder().getClass().getClassLoader());
        try {
            AbstractBuilder b = this.getBuilder();
            argument.getLogger().prime();
            b.build(argument);
        }
        finally {
            t.setContextClassLoader(old);
        }
    }

    public void generateEclipseProjectSettings(IGenConfArgument argument) throws BuildPluginException {
        Thread t = Thread.currentThread();
        ClassLoader old = t.getContextClassLoader();
        t.setContextClassLoader(this.getBuilder().getClass().getClassLoader());
        try {
            ((IEclipseNature)this.getBuilder()).generateEclipseProjectSettings(argument);
        }
        finally {
            t.setContextClassLoader(old);
        }
    }

    public String toString() {
        return this.module.key + " " + this.propList;
    }
}

